/**
 * @file DeviceRingtoneList.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the DeviceRingtoneList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "DeviceRingtoneList.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceRingtoneList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   DeviceRingtoneList::DeviceRingtoneList() : _deviceRingtoneList()
   {
   }

   DeviceRingtoneList::DeviceRingtoneList(const DeviceRingtoneListType deviceRingtoneList) :
      _deviceRingtoneList(deviceRingtoneList)
   {
   }

   DeviceRingtoneList::DeviceRingtoneList(const DeviceRingtoneList& other) :
      _deviceRingtoneList(other._deviceRingtoneList)
   {
   }

   DeviceRingtoneList::~DeviceRingtoneList()
   {
   }

   void swap(DeviceRingtoneList& first, DeviceRingtoneList& second)
   {
      using std::swap;

      swap(first._deviceRingtoneList, second._deviceRingtoneList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DeviceRingtoneList& DeviceRingtoneList::operator=(DeviceRingtoneList other)
   {
      swap(*this, other);

      return *this;
   }

   bool DeviceRingtoneList::operator==(const DeviceRingtoneList& rhs) const
   {
      return (this->_deviceRingtoneList == rhs._deviceRingtoneList);
   }

   bool DeviceRingtoneList::operator!=(const DeviceRingtoneList& rhs) const
   {
      return (!(this->_deviceRingtoneList == rhs._deviceRingtoneList));
   }
}
