/**
 * @file DeviceRingtone.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the DeviceRingtone class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "DeviceRingtone.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceRingtone.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   DeviceRingtone::DeviceRingtone() :
         _deviceAddress(""),
         _ringtoneId(RINGTONE_ID_DEFAULT),
         _ringtoneName(""),
         _inbandRingingSupport(NOT_SUPPORTED)
   {
   }

   DeviceRingtone::DeviceRingtone(const BdAddress deviceAddress, const RingtoneId ringtoneId,
         const RingtoneName ringtoneName, const InbandRingingSupport inbandRingingSupport) :
      _deviceAddress(deviceAddress),
      _ringtoneId(ringtoneId),
      _ringtoneName(ringtoneName),
      _inbandRingingSupport(inbandRingingSupport)
   {
   }

   DeviceRingtone::DeviceRingtone(const DeviceRingtone& other) :
      _deviceAddress(other._deviceAddress),
      _ringtoneId(other._ringtoneId),
      _ringtoneName(other._ringtoneName),
      _inbandRingingSupport(other._inbandRingingSupport)
   {
   }

   DeviceRingtone::~DeviceRingtone()
   {
   }

   void swap(DeviceRingtone& first, DeviceRingtone& second)
   {
      using std::swap;

      swap(first._deviceAddress, second._deviceAddress);
      swap(first._ringtoneId, second._ringtoneId);
      swap(first._ringtoneName, second._ringtoneName);
      swap(first._inbandRingingSupport, second._inbandRingingSupport);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DeviceRingtone& DeviceRingtone::operator=(DeviceRingtone other)
   {
      swap(*this, other);

      return *this;
   }

   bool DeviceRingtone::operator==(const DeviceRingtone& rhs) const
   {
      return ((this->_deviceAddress == rhs._deviceAddress)
            && (this->_ringtoneId == rhs._ringtoneId)
            && (this->_ringtoneName == rhs._ringtoneName)
            && (this->_inbandRingingSupport == rhs._inbandRingingSupport));
   }

   bool DeviceRingtone::operator!=(const DeviceRingtone& rhs) const
   {
      return (!((this->_deviceAddress == rhs._deviceAddress)
            && (this->_ringtoneId == rhs._ringtoneId)
            && (this->_ringtoneName == rhs._ringtoneName)
            && (this->_inbandRingingSupport == rhs._inbandRingingSupport)));
   }
}
