/**
 * @file DeviceIdentification.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the DeviceIdentification class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for DeviceIdentification class
 *
 * @ingroup IpcWrapper
 */

#include "DeviceIdentification.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceIdentification.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{

DeviceIdentification::DeviceIdentification() : _vendorId(VENDOR_ID_INVALID), _vendorIdSource(VENDOR_ID_SOURCE_INVALID)
{
   ETG_TRACE_USR4(("DeviceIdentification::DeviceIdentification() entered"));
}

DeviceIdentification::~DeviceIdentification()
{
   ETG_TRACE_USR4(("DeviceIdentification::~DeviceIdentification() entered"));
}

DeviceIdentification::DeviceIdentification(unsigned short int vendorId, unsigned short int vendorIdSource)
: _vendorId(vendorId), _vendorIdSource(vendorIdSource)
{
   ETG_TRACE_USR4(("DeviceIdentification::DeviceIdentification() Parameterized constructor entered"));
}

DeviceIdentification::DeviceIdentification(const DeviceIdentification& deviceIdentification)
: _vendorId(deviceIdentification._vendorId), _vendorIdSource(deviceIdentification._vendorIdSource)
{
   ETG_TRACE_USR4(("DeviceIdentification::DeviceIdentification() Copy constructor entered"));
}

void swap(DeviceIdentification& first, DeviceIdentification& second)
{
   using std::swap;

   swap(first._vendorId, second._vendorId);
   swap(first._vendorIdSource, second._vendorIdSource);
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
DeviceIdentification& DeviceIdentification::operator=(DeviceIdentification other)
{
   swap(*this, other);
   return *this;
}

bool DeviceIdentification::operator==(const DeviceIdentification& rhs) const
{
   return ((this->_vendorId == rhs._vendorId) && (this->_vendorIdSource == rhs._vendorIdSource));
}

void DeviceIdentification::printDeviceIdentificationInfo()
{
   ETG_TRACE_USR4(("DeviceIdentification::printDeviceIdentificationInfo() entered"));

   ETG_TRACE_USR4(("vendorId: %u", _vendorId));
   ETG_TRACE_USR4(("vendorIdSource: %u", _vendorIdSource));
}

} // namespace pmcore
