/**
 * @file CallStatusList.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallStatusList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "CallStatusList.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CallStatusList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   CallStatusList::CallStatusList() :
         _callStatusList()
   {
   }

   CallStatusList::CallStatusList(const CallStatusListMap callStatusList) :
         _callStatusList(callStatusList)
   {
   }

   CallStatusList::CallStatusList(const CallStatusList& other) :
         _callStatusList(other._callStatusList)
   {
   }

   CallStatusList::~CallStatusList()
   {
   }

   void swap(CallStatusList& first, CallStatusList& second)
   {
      using std::swap;

      swap(first._callStatusList, second._callStatusList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   CallStatusList& CallStatusList::operator=(CallStatusList other)
   {
      swap(*this, other);

      return *this;
   }

   bool CallStatusList::operator==(const CallStatusList& rhs) const
   {
      return (this->_callStatusList == rhs._callStatusList);
   }

   bool CallStatusList::operator!=(const CallStatusList& rhs) const
   {
      return (!(this->_callStatusList == rhs._callStatusList));
   }
}
