/**
 * @file CallStatus.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef CallStatus_h
#define CallStatus_h

#include "CallInfo.h"

namespace pmcore
{
   class CallStatus
   {
   public:
      /**
       * Constructor of CallStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallStatus();

      /**
       * Parameterized Constructor of CallStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallStatus(const Multiparty multiparty, const CallInfoList callInfoList);

      /**
       * Copy Constructor of CallStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallStatus(const CallStatus& other);

      /**
       * Destructor of CallStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~CallStatus();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(CallStatus& first, CallStatus& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      CallStatus& operator=(CallStatus other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const CallStatus& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const CallStatus& rhs) const;

      Multiparty   _multiparty;   /**< multiparty */
      CallInfoList _callInfoList; /**< call info list */
   };

   typedef std::map<BdAddress, CallStatus> CallStatusListMap; /**< call status list map */

} // namespace pmcore

#endif // CallStatus_h
