/**
 * @file CallStatus.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "CallStatus.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CallStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   CallStatus::CallStatus() :
         _multiparty(false),
         _callInfoList()
   {
   }

   CallStatus::CallStatus(const Multiparty multiparty, const CallInfoList callInfoList) :
         _multiparty(multiparty),
         _callInfoList(callInfoList)
   {
   }

   CallStatus::CallStatus(const CallStatus& other) :
         _multiparty(other._multiparty),
         _callInfoList(other._callInfoList)
   {
   }

   CallStatus::~CallStatus()
   {
   }

   void swap(CallStatus& first, CallStatus& second)
   {
      using std::swap;

      swap(first._multiparty, second._multiparty);
      swap(first._callInfoList, second._callInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   CallStatus& CallStatus::operator=(CallStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool CallStatus::operator==(const CallStatus& rhs) const
   {
      return ((this->_multiparty == rhs._multiparty)
            && (this->_callInfoList == rhs._callInfoList));
   }

   bool CallStatus::operator!=(const CallStatus& rhs) const
   {
      return (!((this->_multiparty == rhs._multiparty)
            && (this->_callInfoList == rhs._callInfoList)));
   }
}
