/**
 * @file BatteryChargeLevel.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the BatteryChargeLevel class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef BatteryChargeLevel_h
#define BatteryChargeLevel_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class BatteryChargeLevel
   {
   public:
      /**
       * Constructor of BatteryChargeLevel class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      BatteryChargeLevel();

      /**
       * Parameterized Constructor of BatteryChargeLevel class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      BatteryChargeLevel(const BatteryChargeLevelType batteryChargeLevel);

      /**
       * Copy Constructor of BatteryChargeLevel class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      BatteryChargeLevel(const BatteryChargeLevel& other);

      /**
       * Destructor of BatteryChargeLevel class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~BatteryChargeLevel();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(BatteryChargeLevel& first, BatteryChargeLevel& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BatteryChargeLevel& operator=(BatteryChargeLevel other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const BatteryChargeLevel& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const BatteryChargeLevel& rhs) const;

      BatteryChargeLevelType _batteryChargeLevel; /**< battery charge level */
   };

} // namespace pmcore

#endif // BatteryChargeLevel_h
