/**
 * @file BasicDeviceDetails.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the BasicDeviceDetails class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for BasicDeviceDetails class
 *
 * @ingroup IpcWrapper
 */

#include "BasicDeviceDetails.h"

#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BasicDeviceDetails.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{

BasicDeviceDetails::BasicDeviceDetails()
: _deviceAddress(""), _deviceHandle(PM_DEVICEHANDLE_ZERO),
  _deviceIdentification(VENDOR_ID_INVALID, VENDOR_ID_SOURCE_INVALID)
{
   ETG_TRACE_USR4(("BasicDeviceDetails::BasicDeviceDetails() entered"));
}

BasicDeviceDetails::BasicDeviceDetails(const BdAddress& deviceAddress, const DeviceHandle deviceHandle,
      const DeviceIdentification& deviceIdentification)
: _deviceAddress(deviceAddress), _deviceHandle(deviceHandle), _deviceIdentification(deviceIdentification)
{
   ETG_TRACE_USR4(("BasicDeviceDetails::BasicDeviceDetails() Parameterized constructor entered"));
}

BasicDeviceDetails::BasicDeviceDetails(const BasicDeviceDetails& other)
: _deviceAddress(other._deviceAddress), _deviceHandle(other._deviceHandle),
  _deviceIdentification(other._deviceIdentification)

{
   ETG_TRACE_USR4(("BasicDeviceDetails::BasicDeviceDetails() Copy constructor entered"));
}

BasicDeviceDetails::~BasicDeviceDetails()
{
   ETG_TRACE_USR4(("BasicDeviceDetails::~BasicDeviceDetails() entered"));
}

void swap(BasicDeviceDetails& first, BasicDeviceDetails& second)
{
   using std::swap;

   swap(first._deviceAddress, second._deviceAddress);
   swap(first._deviceHandle, second._deviceHandle);
   swap(first._deviceIdentification, second._deviceIdentification);
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
BasicDeviceDetails& BasicDeviceDetails::operator=(BasicDeviceDetails other)
{
   swap(*this, other);
   return *this;
}

bool BasicDeviceDetails::operator==(const BasicDeviceDetails& rhs) const
{
   return ((this->_deviceAddress == rhs._deviceAddress)
         && (this->_deviceHandle == rhs._deviceHandle)
         && (this->_deviceIdentification == rhs._deviceIdentification));
}

void BasicDeviceDetails::printDeviceIdentity()
{
   ETG_TRACE_USR4(("BasicDeviceDetails::printDeviceIdentity() entered"));

   ETG_TRACE_USR4(("BasicDeviceDetails: deviceAddress: %s", _deviceAddress.c_str()));
   ETG_TRACE_USR4(("BasicDeviceDetails: deviceHandle: %u", _deviceHandle));
   _deviceIdentification.printDeviceIdentificationInfo();
}

} // namespace pmcore
