/**
 * @file BTSVoiceCallInfo.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the BTSVoiceCallInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef BTSVoiceCallInfo_h
#define BTSVoiceCallInfo_h

#include "PmInterfaceTypesInternal.h"
#include "CallInfo.h"

namespace pmcore
{
   //forward declaration
   //class CallInfo;

   class BTSVoiceCallInfo
   {
   public:
      /**
       * Constructor of BTSVoiceCallInfo class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      BTSVoiceCallInfo();

      /**
       * Parameterized Constructor of BTSVoiceCallInfo class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      BTSVoiceCallInfo(const CallInfo callInfo, const ContactName& contactName, const Multiparty multiparty,
            const Emergency emergency);

      /**
       * Copy Constructor of BTSVoiceCallInfo class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      BTSVoiceCallInfo(const BTSVoiceCallInfo& other);

      /**
       * Destructor of CallInfo class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~BTSVoiceCallInfo();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(BTSVoiceCallInfo& first, BTSVoiceCallInfo& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BTSVoiceCallInfo& operator=(BTSVoiceCallInfo other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const BTSVoiceCallInfo& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const BTSVoiceCallInfo& rhs) const;

      CallInfo    _callInfo;    /**< instance of CallInfo */
      ContactName _contactName; /**< contact name */
      Multiparty  _multiparty;  /**< multiparty */
      Emergency   _emergency;   /**< emergency */
   };

   typedef std::vector<BTSVoiceCallInfo> BTSVoiceCallInfoList; /**< BTS voice call info list */

} // namespace pmcore

#endif // CallInfo_h
