/**
 * @file BTSResult.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the BTSResult class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup pmcore
 */

#ifndef BTSResult_h
#define BTSResult_h

#include "PmInterfaceTypesInternal.h"
#include "BtStackWrapperTypesInternal.h"
#include "EvolutionGeniviDbusTypes.h"

namespace pmcore
{
   class BTSResult
   {
   public:
      /**
       * Constructor of BTSResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      BTSResult();

      /**
       * Parameterized Constructor of BTSResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      BTSResult(const BTSRequestResult btsRequestResult, const ::ccdbusif::evolution::ErrorCode errorCode,
            const ::evobtstackwrapper::ErrorMessage& errorMessage);

      /**
       * Copy Constructor of BTSResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      BTSResult(const BTSResult& other);

      /**
       * Destructor of BTSResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      ~BTSResult();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      friend void swap(BTSResult& first, BTSResult& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BTSResult& operator=(BTSResult other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      bool operator==(const BTSResult& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      bool operator!=(const BTSResult& rhs) const;

      BTSRequestResult                     _btsRequestResult;  /**< BTS request result */
      ::ccdbusif::evolution::ErrorCode     _errorCode;         /**< BTS error code */
      ::evobtstackwrapper::ErrorMessage    _errorMessage;      /**< BTS error message */
   };

} //pmcore

#endif // BTSResult_h
