/**
 * @file BTSResult.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the BTSResult class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup pmcore
 */

#include "BTSResult.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BTSResult.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   BTSResult::BTSResult() :
         _btsRequestResult(BTS_REQ_SUCCESS),
         _errorCode(::ccdbusif::evolution::ERROR_UNKNOWN),
         _errorMessage("")
   {
   }

   BTSResult::BTSResult(const BTSRequestResult btsRequestResult, const ::ccdbusif::evolution::ErrorCode errorCode,
         const ::evobtstackwrapper::ErrorMessage& errorMessage) :
         _btsRequestResult(btsRequestResult),
         _errorCode(errorCode),
         _errorMessage(errorMessage)
   {
   }

   BTSResult::BTSResult(const BTSResult& other) :
      _btsRequestResult(other._btsRequestResult),
      _errorCode(other._errorCode),
      _errorMessage(other._errorMessage)
   {
   }

   BTSResult::~BTSResult()
   {
   }

   void swap(BTSResult& first, BTSResult& second)
   {
      using std::swap;

      swap(first._btsRequestResult, second._btsRequestResult);
      swap(first._errorCode, second._errorCode);
      swap(first._errorMessage, second._errorMessage);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BTSResult& BTSResult::operator=(BTSResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BTSResult::operator==(const BTSResult& rhs) const
   {
      return ((this->_btsRequestResult == rhs._btsRequestResult)
            && (this->_errorCode == rhs._errorCode)
            && (this->_errorMessage == rhs._errorMessage));
   }

   bool BTSResult::operator!=(const BTSResult& rhs) const
   {
      return (!((this->_btsRequestResult == rhs._btsRequestResult)
            && (this->_errorCode == rhs._errorCode)
            && (this->_errorMessage == rhs._errorMessage)));
   }

} // pmcore
