/**
 * @file AutoWaitingModeOnOffList.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AutoWaitingModeOnOffList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef AutoWaitingModeOnOffList_h
#define AutoWaitingModeOnOffList_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class AutoWaitingModeOnOffList
   {
   public:
      /**
       * Constructor of AutoWaitingModeOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AutoWaitingModeOnOffList();

      /**
       * Parameterized Constructor of AutoWaitingModeOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AutoWaitingModeOnOffList(const AutoWaitingModeOnOffListMap autoWaitingModeOnOffList);

      /**
       * Copy Constructor of AutoWaitingModeOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AutoWaitingModeOnOffList(const AutoWaitingModeOnOffList& other);

      /**
       * Destructor of AutoWaitingModeOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~AutoWaitingModeOnOffList();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(AutoWaitingModeOnOffList& first, AutoWaitingModeOnOffList& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      AutoWaitingModeOnOffList& operator=(AutoWaitingModeOnOffList other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const AutoWaitingModeOnOffList& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const AutoWaitingModeOnOffList& rhs) const;

      AutoWaitingModeOnOffListMap _autoWaitingModeOnOffList; /**< auto waiting mode on off list map */
   };

} // namespace pmcore

#endif // AutoWaitingModeOnOffList_h
