/**
 * @file AutoWaitingModeOnOffList.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AutoWaitingModeOnOffList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "AutoWaitingModeOnOffList.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AutoWaitingModeOnOffList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   AutoWaitingModeOnOffList::AutoWaitingModeOnOffList() : _autoWaitingModeOnOffList()
   {
   }

   AutoWaitingModeOnOffList::AutoWaitingModeOnOffList(const AutoWaitingModeOnOffListMap autoWaitingModeOnOffList) :
      _autoWaitingModeOnOffList(autoWaitingModeOnOffList)
   {
   }

   AutoWaitingModeOnOffList::AutoWaitingModeOnOffList(const AutoWaitingModeOnOffList& other) :
      _autoWaitingModeOnOffList(other._autoWaitingModeOnOffList)
   {
   }

   AutoWaitingModeOnOffList::~AutoWaitingModeOnOffList()
   {
   }

   void swap(AutoWaitingModeOnOffList& first, AutoWaitingModeOnOffList& second)
   {
      using std::swap;

      swap(first._autoWaitingModeOnOffList, second._autoWaitingModeOnOffList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   AutoWaitingModeOnOffList& AutoWaitingModeOnOffList::operator=(AutoWaitingModeOnOffList other)
   {
      swap(*this, other);

      return *this;
   }

   bool AutoWaitingModeOnOffList::operator==(const AutoWaitingModeOnOffList& rhs) const
   {
      return (this->_autoWaitingModeOnOffList == rhs._autoWaitingModeOnOffList);
   }

   bool AutoWaitingModeOnOffList::operator!=(const AutoWaitingModeOnOffList& rhs) const
   {
      return (!(this->_autoWaitingModeOnOffList == rhs._autoWaitingModeOnOffList));
   }
}
