/**
 * @file AutoRejectCall.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AutoRejectCall class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef AutoRejectCall_h
#define AutoRejectCall_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class AutoRejectCall
   {
   public:
      /**
       * Constructor of AutoRejectCall class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AutoRejectCall();

      /**
       * Parameterized constructor of AutoRejectCall class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AutoRejectCall(const CallInstance instance, const TelephoneNumber telephoneNumber,
            const AutoRejectRequestReason autoRejectRequestReason);

      /**
       * Copy constructor of AutoRejectCall class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AutoRejectCall(const AutoRejectCall& other);

      /**
       * Destructor of AutoRejectCall class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~AutoRejectCall();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(AutoRejectCall& first, AutoRejectCall& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      AutoRejectCall& operator=(AutoRejectCall other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const AutoRejectCall& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const AutoRejectCall& rhs) const;

      CallInstance _instance;
      TelephoneNumber _telephoneNumber;
      AutoRejectRequestReason _autoRejectRequestReason;
   };

} // namespace pmcore

#endif // WatingModeStateType_h
