/**
 * @file AutoRejectCall.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AutoRejectCall class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "AutoRejectCall.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AutoRejectCall.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   AutoRejectCall::AutoRejectCall() : _instance(CALL_INSTANCE_DEFAULT), _telephoneNumber(""),
         _autoRejectRequestReason(REJECT_REASON_UNKNOWN)
   {
   }

   AutoRejectCall::AutoRejectCall(const CallInstance instance, const TelephoneNumber telephoneNumber,
         const AutoRejectRequestReason autoRejectRequestReason) :
      _instance(instance), _telephoneNumber(telephoneNumber), _autoRejectRequestReason(autoRejectRequestReason)
   {
   }

   AutoRejectCall::AutoRejectCall(const AutoRejectCall& other) :
         _instance(other._instance), _telephoneNumber(other._telephoneNumber),
         _autoRejectRequestReason(other._autoRejectRequestReason)
   {
   }

   AutoRejectCall::~AutoRejectCall()
   {
   }

   void swap(AutoRejectCall& first, AutoRejectCall& second)
   {
      using std::swap;

      swap(first._instance, second._instance);
      swap(first._telephoneNumber, second._telephoneNumber);
      swap(first._autoRejectRequestReason, second._autoRejectRequestReason);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   AutoRejectCall& AutoRejectCall::operator=(AutoRejectCall other)
   {
      swap(*this, other);

      return *this;
   }

   bool AutoRejectCall::operator==(const AutoRejectCall& rhs) const
   {
      return ((this->_instance == rhs._instance)
            && (this->_telephoneNumber == rhs._telephoneNumber)
            && (this->_autoRejectRequestReason == rhs._autoRejectRequestReason));
   }

   bool AutoRejectCall::operator!=(const AutoRejectCall& rhs) const
   {
      return (!(operator==(rhs)));
   }
}
