/**
 * @file PmCoreIfTypes.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the Include files of PmCore Types
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the include files of PmCore Types.
 *
 * @ingroup PmCore
 */

#ifndef PmCoreIfTypes_h
#define PmCoreIfTypes_h

#include "Types/PmInterfaceTypesInternal.h"
#include "Types/PmCoreInternalTypeConversion.h"
#include "Types/ActivePassiveDeviceList.h"
#include "Types/AutoWaitingModeOnOffList.h"
#include "Types/BasicDeviceDetails.h"
#include "Types/BatteryChargeLevel.h"
#include "Types/BTSResult.h"
#include "Types/BTSVoiceCallInfo.h"
#include "Types/CallInfo.h"
#include "Types/CallStatus.h"
#include "Types/CallStatusList.h"
#include "Types/DeviceIdentification.h"
#include "Types/DeviceRingtone.h"
#include "Types/DeviceRingtoneList.h"
#include "Types/EnhancedVoiceRecognitionFeature.h"
#include "Types/FriendlyName.h"
#include "Types/MicrophoneMuteState.h"
#include "Types/NetworkOperator.h"
#include "Types/NetworkStatus.h"
#include "Types/PhoneCallAudioActive.h"
#include "Types/PmResult.h"
#include "Types/RingtoneMuteState.h"
#include "Types/SCOConnection.h"
#include "Types/SignalStrength.h"
#include "Types/SupportedFeatures.h"
#include "Types/SuppressRingtoneOnOffList.h"
#include "Types/SystemRingtones.h"
#include "Types/SystemWideRingtonesList.h"
#include "Types/VehicleConfiguration.h"
#include "Types/VoiceMail.h"
#include "Types/VoiceRecognitionStatus.h"
#include "Types/ExtVoiceRecognitionStatus.h"
#include "Types/WaitingModeFilePath.h"
#include "Types/WaitingModeState.h"
#include "Types/AutoRejectCall.h"
#include "Types/RingtonePlaybackState.h"

#endif // PmCoreIfTypes_h
