/* *
 * @file PmCallStateHandlerSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from PmCallStateHandlerSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#ifndef PMCALLSTATEHANDLERSM_H_
#define PMCALLSTATEHANDLERSM_H_


#include <PmCoreSmTypes.h>
#include <PmCoreIfMessageRequest.h>
#include <PmCoreIfMessage.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'PmCallStateHandlerSm'.
*/


#ifndef SCT_EVENTS_PMCALLSTATEHANDLERSM_H
#define SCT_EVENTS_PMCALLSTATEHANDLERSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace pmcallstatehandlersm_events
{
typedef enum  {
	pmcallstatehandlersm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_UserAction_DIAL_CALL,
	SCI_UserAction_ACCEPT_CALL,
	SCI_UserAction_SPEED_DIAL,
	SCI_UserAction_REDIAL,
	SCI_UserAction_HANGUP_CALLS,
	SCI_UserAction_HANGUP_ALL_CALLS,
	SCI_UserAction_SWAP_CALLS,
	SCI_UserAction_SPLIT_CALLS,
	SCI_UserAction_CONFERENCE_CALL,
	SCI_UserAction_TRANSFER_AUDIO_TO_AG,
	SCI_UserAction_TRANSFER_AUDIO_TO_HF,
	SCI_UserAction_MUTE_RINGTONE,
	SCI_UserAction_START_WAITING_MODE,
	SCI_UserAction_STOP_WAITING_MODE,
	SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH,
	SCI_AgCallStateUpdate_IDLE,
	SCI_AgCallStateUpdate_INCOMING,
	SCI_AgCallStateUpdate_INCOMING_INBAND,
	SCI_AgCallStateUpdate_DIALING,
	SCI_AgCallStateUpdate_HELD,
	SCI_AgCallStateUpdate_ACTIVE,
	SCI_AgCallStateUpdate_CALL_DISCONNECTING,
	SCI_AgCallStateUpdate_CALL_DISCONNECTED,
	SCI_AgCallStateUpdate_CALL_X_DIALING,
	SCI_AgCallStateUpdate_CALL_X_WAITING,
	SCI_AgCallStateUpdate_CALLS_SWAPPABLE,
	SCI_AgCallStateUpdate_CALLS_CONFERENCE,
	SCI_AgCallStateUpdate_ALL_CALLS_DISCONNECTED,
	SCI_AgAudioUpdate_SCO_CONNECTED,
	SCI_AgAudioUpdate_SCO_PAUSED,
	SCI_AgAudioUpdate_SCO_DISCONNECTED,
	SCI_SmHandler_SWITCH_TO_PASSIVE,
	SCI_SmHandler_SWITCH_TO_ACTIVE,
	SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED,
	SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED,
	SCI_AudioManagerResponse_PHONE_CHANNEL_GRANTED,
	SCI_AudioManagerResponse_PHONE_CHANNEL_DENIED,
	SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_GRANTED,
	SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_DENIED,
	SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS,
	SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE,
	SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS,
	SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE,
	SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS,
	SCI_AudioManagerResponse_STOP_AUDIO_FAILURE,
	SCI_AudioManagerResponse_PHONE_CHANNEL_RELEASED,
	SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED,
	SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_RELEASED,
	SCI_AgResponse_ACCEPT_OK,
	SCI_AgResponse_DIAL_OK,
	SCI_AgResponse_HOLD_INCOMING_OK,
	SCI_AgResponse_HANGUP_OK,
	SCI_AgResponse_CONF_OK,
	SCI_AgResponse_SWAP_OK,
	SCI_AgResponse_SPLIT_OK,
	SCI_AgResponse_SPEED_DIAL_OK,
	SCI_AgResponse_ACCEPT_SCO_CONNECT_OK,
	SCI_AgResponse_GET_CALLS_OK,
	SCI_AgResponse_REDIAL_OK,
	SCI_AgResponse_TRANSFER_OK,
	SCI_AgResponse_RELEASE_AND_ACCEPT_OK,
	SCI_AgResponse_RELEASE_AND_SWAP_OK,
	SCI_AgResponse_HOLD_AND_ACCEPT_OK,
	SCI_AgResponse_HANGUP_ALL_OK,
	SCI_AgResponse_HANGUP_MULTIPARTY_OK,
	SCI_AgResponse_SEND_DTMF_OK,
	SCI_AgResponse_DEFAULT_ERROR,
	SCI_AgResponse_ACCEPT_ERROR,
	SCI_AgResponse_DIAL_ERROR,
	SCI_AgResponse_HOLD_INCOMING_ERROR,
	SCI_AgResponse_SPEED_DIAL_ERROR,
	SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR,
	SCI_AgResponse_GET_CALLS_ERROR,
	SCI_AgResponse_REDIAL_ERROR,
	SCI_AgResponse_TRANSFER_ERROR,
	SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR,
	SCI_AgResponse_RELEASE_AND_SWAP_ERROR,
	SCI_AgResponse_HOLD_AND_ACCEPT_ERROR,
	SCI_AgResponse_SEND_DTMF_ERROR,
	SCI_TimerUpdate_TIMER_CALLBACK,
	InternalSCI_CHECK_AUDIO,
	InternalSCI_GENERATE_CALL_STATE_EVENT,
	InternalSCI_TO_START_WAITING_MODE,
	InternalSCI_MOVE_TO_NEXT_STATE
} PmCallStateHandlerSmEventName;

class SctEvent
{
	public:
		SctEvent(PmCallStateHandlerSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const PmCallStateHandlerSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(PmCallStateHandlerSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_UserAction_DIAL_CALL : public TypedSctEvent<pmcore::PmCoreIfMessage_DialRequest *>
{
	public:
		SctEvent_SCI_UserAction_DIAL_CALL(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_DialRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_ACCEPT_CALL : public TypedSctEvent<pmcore::PmCoreIfMessage_AcceptCallRequest *>
{
	public:
		SctEvent_SCI_UserAction_ACCEPT_CALL(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_AcceptCallRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_SPEED_DIAL : public TypedSctEvent<pmcore::PmCoreIfMessage_SpeedDialRequest *>
{
	public:
		SctEvent_SCI_UserAction_SPEED_DIAL(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_SpeedDialRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_REDIAL : public TypedSctEvent<pmcore::PmCoreIfMessage_RedialRequest *>
{
	public:
		SctEvent_SCI_UserAction_REDIAL(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_RedialRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_HANGUP_CALLS : public TypedSctEvent<pmcore::PmCoreIfMessage_HangupCallsRequest *>
{
	public:
		SctEvent_SCI_UserAction_HANGUP_CALLS(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_HangupCallsRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_HANGUP_ALL_CALLS : public TypedSctEvent<pmcore::PmCoreIfMessage_HangupCallsRequest *>
{
	public:
		SctEvent_SCI_UserAction_HANGUP_ALL_CALLS(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_HangupCallsRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_SWAP_CALLS : public TypedSctEvent<pmcore::PmCoreIfMessage_SwapCallRequest *>
{
	public:
		SctEvent_SCI_UserAction_SWAP_CALLS(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_SwapCallRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_SPLIT_CALLS : public TypedSctEvent<pmcore::PmCoreIfMessage_SplitCallsRequest *>
{
	public:
		SctEvent_SCI_UserAction_SPLIT_CALLS(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_SplitCallsRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_CONFERENCE_CALL : public TypedSctEvent<pmcore::PmCoreIfMessage_MergeCallsRequest *>
{
	public:
		SctEvent_SCI_UserAction_CONFERENCE_CALL(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_MergeCallsRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_AG : public TypedSctEvent<pmcore::PmCoreIfMessage_TransferAudioRequest *>
{
	public:
		SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_AG(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_TransferAudioRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_HF : public TypedSctEvent<pmcore::PmCoreIfMessage_TransferAudioRequest *>
{
	public:
		SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_HF(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_TransferAudioRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_MUTE_RINGTONE : public TypedSctEvent<pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest *>
{
	public:
		SctEvent_SCI_UserAction_MUTE_RINGTONE(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_START_WAITING_MODE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_START_WAITING_MODE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_STOP_WAITING_MODE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_STOP_WAITING_MODE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH : public TypedSctEvent<pmcore::PmCoreIfMessage_AcceptCallRequest *>
{
	public:
		SctEvent_SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage_AcceptCallRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgCallStateUpdate_IDLE : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_IDLE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_INCOMING : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_INCOMING(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_INCOMING_INBAND : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_INCOMING_INBAND(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_DIALING : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_DIALING(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_HELD : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_HELD(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_ACTIVE : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_ACTIVE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_CALL_DISCONNECTING : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_CALL_DISCONNECTING(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_CALL_DISCONNECTED : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_CALL_DISCONNECTED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_CALL_X_DIALING : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_CALL_X_DIALING(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_CALL_X_WAITING : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_CALL_X_WAITING(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_CALLS_SWAPPABLE : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_CALLS_SWAPPABLE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_CALLS_CONFERENCE : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_CALLS_CONFERENCE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgCallStateUpdate_ALL_CALLS_DISCONNECTED : public SctEvent
{
	public:
		SctEvent_SCI_AgCallStateUpdate_ALL_CALLS_DISCONNECTED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED : public TypedSctEvent<SCOStatus>
{
	public:
		SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED(PmCallStateHandlerSmEventName name, SCOStatus value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgAudioUpdate_SCO_PAUSED : public TypedSctEvent<SCOStatus>
{
	public:
		SctEvent_SCI_AgAudioUpdate_SCO_PAUSED(PmCallStateHandlerSmEventName name, SCOStatus value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED : public TypedSctEvent<SCOStatus>
{
	public:
		SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED(PmCallStateHandlerSmEventName name, SCOStatus value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_SmHandler_SWITCH_TO_PASSIVE : public SctEvent
{
	public:
		SctEvent_SCI_SmHandler_SWITCH_TO_PASSIVE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_SmHandler_SWITCH_TO_ACTIVE : public SctEvent
{
	public:
		SctEvent_SCI_SmHandler_SWITCH_TO_ACTIVE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_GRANTED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_DENIED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_GRANTED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_DENIED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_FAILURE : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_FAILURE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_RELEASED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_RELEASED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_RELEASED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_RELEASED(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_ACCEPT_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_ACCEPT_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_DIAL_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_DIAL_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_HOLD_INCOMING_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_HOLD_INCOMING_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_HANGUP_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_HANGUP_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_CONF_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_CONF_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_SWAP_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_SWAP_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_SPLIT_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_SPLIT_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_SPEED_DIAL_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_SPEED_DIAL_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_GET_CALLS_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_GET_CALLS_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_REDIAL_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_REDIAL_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_TRANSFER_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_TRANSFER_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_HANGUP_ALL_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_HANGUP_ALL_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_HANGUP_MULTIPARTY_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_HANGUP_MULTIPARTY_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_SEND_DTMF_OK : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_SEND_DTMF_OK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_DEFAULT_ERROR : public SctEvent
{
	public:
		SctEvent_SCI_AgResponse_DEFAULT_ERROR(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgResponse_ACCEPT_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_ACCEPT_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_DIAL_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_DIAL_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_HOLD_INCOMING_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_HOLD_INCOMING_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_SPEED_DIAL_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_SPEED_DIAL_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_GET_CALLS_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_GET_CALLS_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_REDIAL_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_REDIAL_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_TRANSFER_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_TRANSFER_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgResponse_SEND_DTMF_ERROR : public TypedSctEvent<pmcore::PmCoreIfMessage *>
{
	public:
		SctEvent_SCI_AgResponse_SEND_DTMF_ERROR(PmCallStateHandlerSmEventName name, pmcore::PmCoreIfMessage * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_TimerUpdate_TIMER_CALLBACK : public SctEvent
{
	public:
		SctEvent_SCI_TimerUpdate_TIMER_CALLBACK(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_CHECK_AUDIO : public SctEvent
{
	public:
		SctEvent_InternalSCI_CHECK_AUDIO(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT : public SctEvent
{
	public:
		SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_TO_START_WAITING_MODE : public SctEvent
{
	public:
		SctEvent_InternalSCI_TO_START_WAITING_MODE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_MOVE_TO_NEXT_STATE : public SctEvent
{
	public:
		SctEvent_InternalSCI_MOVE_TO_NEXT_STATE(PmCallStateHandlerSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_PMCALLSTATEHANDLERSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_MAIN_REGION_CALLHANDLERSM 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTPHONEAUDIO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTSTREAMING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_STREAMINGSTARTED 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_STREAMINGSTOPPED 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORPREPARECHANNELRESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSTOPAUDIORESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTPAUSEAUDIOSTREAMING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_STREAMINGPAUSED 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTSTOPAUDIORINGTONE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORCALLSTATEEVENTTOSTARTWAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSCO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSCODISCONNECTION 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSTARTAUDIORESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORAUDIOCHANNEL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORACTIVECALLSTATUS 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_RECEIVEDACTIVECALLSTATUS 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORCHANNELALLOCATION 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORSTOPAUDIORESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORSTOPAUDIORESPONSETOACCEPTCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_TOSTARTWAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORACCEPTCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_STARTWAITINGMODEAFTERACCEPTRESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_REQUESTSTREAMINGACCEPTINGCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_STARTWAITINGMODEAFTERCHANNELALLOCATION 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORSTOPAUDIORESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORSTOPAUDIORESPONSETOACCEPTCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_STARTTOWAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORACCEPTCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSCO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSEOUTBAND 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORAUDIORESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_OUTBANDCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_OUTBANDCALL_OUTBANDRINGING_REGION_OUTBANDCALLNORINGING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_OUTBANDCALL_OUTBANDRINGING_REGION_OUTBANDRINGING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_REQUESTPLAYHFAUDIO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_INBANDCALLNORINGING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_PLAYAUDIOFAILURE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_WAITFORSTOPAUDIORESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_WAITFORSCO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_INBANDRINGTONESTREAMING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSCOINSWITCHTOACTIVE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_AUDIOCHANNELDENIED 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSEOUTBANDTOACCEPTCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSETOACCEPTCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_WAITFORCALLSTATEEVENT 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING_DISCONNECTING_REGION_WAITFORSTOPRESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING_DISCONNECTING_REGION_REQUESTSTOPAUDIO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING_DISCONNECTING_REGION_WAITFORSCORELEASE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACTIVECALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACTIVECALL_ACTIVECALL_REGION_WAITFORAUDIOEVENTACTIVECALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING_OUTGOING_REGION_WAITFORDIALRESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING_OUTGOING_REGION_WAITFORSCO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING_OUTGOING_REGION_CANCELOUTGOINGCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORAUDIOCHANNEL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTSTREAMING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_STREAMINGSTARTED 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTPHONEAUDIO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTINGAUDIOCHANNEL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_POSTHOLDANDACCEPTWAITINGMODECALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSTOPAUDIORESPONSEAUDIOHANDLING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSCO 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTWAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_POSTACCEPTWAITINGMODECALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSCORINGING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTSTREAMINGRINGING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORAUDIOCHANNELFORACTIVECALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTSTOPSTREAMING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_SENDERROR 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_SWITCHTOPASSIVE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTWAITINGMODEACCEPTING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_RECEIVEDTIMERCALLBACK 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORWAITMODECHANNELAFTERTIMEREXPIRY 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSTOPAUDIORESPONSEXCALLOUTGOINGORWAITING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSTOPAUDIORESPONSEACTIVECALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITINGMODECHANNELDENIED 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORWAITINGMODECHANNELRESPONSETOSTOPWAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORPHONECHANNELRESPONSETOSTARTWAITINGMODE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_HANDLINGHANGUP 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_HANDLINGHANGUP_HANDLINGHANGUP_REGION_WAITFORHANGUPRESPONSE 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_HANDLINGHANGUP_HANDLINGHANGUP_REGION_ACCEPTAFTERHANGUP 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_WAITFORAUDIOEVENTXCALLOUTGOINGORWAITING 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_ACCEPTWAITINGCALL 0
#define SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_IDLE 0


class PmCallStateHandlerSm : public StatemachineInterface
{
	public:
		PmCallStateHandlerSm();
		
		~PmCallStateHandlerSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			PmCallStateHandlerSm_last_state,
			Main_region_CallHandlerSm,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting,
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall,
			Main_region_CallHandlerSm_CallHandler_region_Idle
		} PmCallStateHandlerSmStates;
					
		static const sc_integer numStates = 98;
		
		//! Inner class for UserAction interface scope.
		class SCI_UserAction
		{
			public:
				SCI_UserAction(PmCallStateHandlerSm * parent):
					DIAL_CALL_raised(false),
					DIAL_CALL_value(),
					ACCEPT_CALL_raised(false),
					ACCEPT_CALL_value(),
					SPEED_DIAL_raised(false),
					SPEED_DIAL_value(),
					REDIAL_raised(false),
					REDIAL_value(),
					HANGUP_CALLS_raised(false),
					HANGUP_CALLS_value(),
					HANGUP_ALL_CALLS_raised(false),
					HANGUP_ALL_CALLS_value(),
					SWAP_CALLS_raised(false),
					SWAP_CALLS_value(),
					SPLIT_CALLS_raised(false),
					SPLIT_CALLS_value(),
					CONFERENCE_CALL_raised(false),
					CONFERENCE_CALL_value(),
					TRANSFER_AUDIO_TO_AG_raised(false),
					TRANSFER_AUDIO_TO_AG_value(),
					TRANSFER_AUDIO_TO_HF_raised(false),
					TRANSFER_AUDIO_TO_HF_value(),
					MUTE_RINGTONE_raised(false),
					MUTE_RINGTONE_value(),
					START_WAITING_MODE_raised(false),
					STOP_WAITING_MODE_raised(false),
					ACCEPT_CALL_BY_ACQUIRING_CH_raised(false),
					ACCEPT_CALL_BY_ACQUIRING_CH_value(),
					parent(parent)
				{}
				
				/*! Raises the in event 'DIAL_CALL' that is defined in the interface scope 'UserAction'. */
				void raise_dIAL_CALL(pmcore::PmCoreIfMessage_DialRequest * value);
				
				
				/*! Raises the in event 'ACCEPT_CALL' that is defined in the interface scope 'UserAction'. */
				void raise_aCCEPT_CALL(pmcore::PmCoreIfMessage_AcceptCallRequest * value);
				
				
				/*! Raises the in event 'SPEED_DIAL' that is defined in the interface scope 'UserAction'. */
				void raise_sPEED_DIAL(pmcore::PmCoreIfMessage_SpeedDialRequest * value);
				
				
				/*! Raises the in event 'REDIAL' that is defined in the interface scope 'UserAction'. */
				void raise_rEDIAL(pmcore::PmCoreIfMessage_RedialRequest * value);
				
				
				/*! Raises the in event 'HANGUP_CALLS' that is defined in the interface scope 'UserAction'. */
				void raise_hANGUP_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value);
				
				
				/*! Raises the in event 'HANGUP_ALL_CALLS' that is defined in the interface scope 'UserAction'. */
				void raise_hANGUP_ALL_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value);
				
				
				/*! Raises the in event 'SWAP_CALLS' that is defined in the interface scope 'UserAction'. */
				void raise_sWAP_CALLS(pmcore::PmCoreIfMessage_SwapCallRequest * value);
				
				
				/*! Raises the in event 'SPLIT_CALLS' that is defined in the interface scope 'UserAction'. */
				void raise_sPLIT_CALLS(pmcore::PmCoreIfMessage_SplitCallsRequest * value);
				
				
				/*! Raises the in event 'CONFERENCE_CALL' that is defined in the interface scope 'UserAction'. */
				void raise_cONFERENCE_CALL(pmcore::PmCoreIfMessage_MergeCallsRequest * value);
				
				
				/*! Raises the in event 'TRANSFER_AUDIO_TO_AG' that is defined in the interface scope 'UserAction'. */
				void raise_tRANSFER_AUDIO_TO_AG(pmcore::PmCoreIfMessage_TransferAudioRequest * value);
				
				
				/*! Raises the in event 'TRANSFER_AUDIO_TO_HF' that is defined in the interface scope 'UserAction'. */
				void raise_tRANSFER_AUDIO_TO_HF(pmcore::PmCoreIfMessage_TransferAudioRequest * value);
				
				
				/*! Raises the in event 'MUTE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_mUTE_RINGTONE(pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest * value);
				
				
				/*! Raises the in event 'START_WAITING_MODE' that is defined in the interface scope 'UserAction'. */
				void raise_sTART_WAITING_MODE();
				
				
				/*! Raises the in event 'STOP_WAITING_MODE' that is defined in the interface scope 'UserAction'. */
				void raise_sTOP_WAITING_MODE();
				
				
				/*! Raises the in event 'ACCEPT_CALL_BY_ACQUIRING_CH' that is defined in the interface scope 'UserAction'. */
				void raise_aCCEPT_CALL_BY_ACQUIRING_CH(pmcore::PmCoreIfMessage_AcceptCallRequest * value);
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				/*! Raises the in event 'DIAL_CALL' that is defined in the interface scope 'UserAction'. */
				void internal_raise_dIAL_CALL(pmcore::PmCoreIfMessage_DialRequest * value);
				sc_boolean DIAL_CALL_raised;
				pmcore::PmCoreIfMessage_DialRequest * DIAL_CALL_value;
				/*! Raises the in event 'ACCEPT_CALL' that is defined in the interface scope 'UserAction'. */
				void internal_raise_aCCEPT_CALL(pmcore::PmCoreIfMessage_AcceptCallRequest * value);
				sc_boolean ACCEPT_CALL_raised;
				pmcore::PmCoreIfMessage_AcceptCallRequest * ACCEPT_CALL_value;
				/*! Raises the in event 'SPEED_DIAL' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sPEED_DIAL(pmcore::PmCoreIfMessage_SpeedDialRequest * value);
				sc_boolean SPEED_DIAL_raised;
				pmcore::PmCoreIfMessage_SpeedDialRequest * SPEED_DIAL_value;
				/*! Raises the in event 'REDIAL' that is defined in the interface scope 'UserAction'. */
				void internal_raise_rEDIAL(pmcore::PmCoreIfMessage_RedialRequest * value);
				sc_boolean REDIAL_raised;
				pmcore::PmCoreIfMessage_RedialRequest * REDIAL_value;
				/*! Raises the in event 'HANGUP_CALLS' that is defined in the interface scope 'UserAction'. */
				void internal_raise_hANGUP_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value);
				sc_boolean HANGUP_CALLS_raised;
				pmcore::PmCoreIfMessage_HangupCallsRequest * HANGUP_CALLS_value;
				/*! Raises the in event 'HANGUP_ALL_CALLS' that is defined in the interface scope 'UserAction'. */
				void internal_raise_hANGUP_ALL_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value);
				sc_boolean HANGUP_ALL_CALLS_raised;
				pmcore::PmCoreIfMessage_HangupCallsRequest * HANGUP_ALL_CALLS_value;
				/*! Raises the in event 'SWAP_CALLS' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sWAP_CALLS(pmcore::PmCoreIfMessage_SwapCallRequest * value);
				sc_boolean SWAP_CALLS_raised;
				pmcore::PmCoreIfMessage_SwapCallRequest * SWAP_CALLS_value;
				/*! Raises the in event 'SPLIT_CALLS' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sPLIT_CALLS(pmcore::PmCoreIfMessage_SplitCallsRequest * value);
				sc_boolean SPLIT_CALLS_raised;
				pmcore::PmCoreIfMessage_SplitCallsRequest * SPLIT_CALLS_value;
				/*! Raises the in event 'CONFERENCE_CALL' that is defined in the interface scope 'UserAction'. */
				void internal_raise_cONFERENCE_CALL(pmcore::PmCoreIfMessage_MergeCallsRequest * value);
				sc_boolean CONFERENCE_CALL_raised;
				pmcore::PmCoreIfMessage_MergeCallsRequest * CONFERENCE_CALL_value;
				/*! Raises the in event 'TRANSFER_AUDIO_TO_AG' that is defined in the interface scope 'UserAction'. */
				void internal_raise_tRANSFER_AUDIO_TO_AG(pmcore::PmCoreIfMessage_TransferAudioRequest * value);
				sc_boolean TRANSFER_AUDIO_TO_AG_raised;
				pmcore::PmCoreIfMessage_TransferAudioRequest * TRANSFER_AUDIO_TO_AG_value;
				/*! Raises the in event 'TRANSFER_AUDIO_TO_HF' that is defined in the interface scope 'UserAction'. */
				void internal_raise_tRANSFER_AUDIO_TO_HF(pmcore::PmCoreIfMessage_TransferAudioRequest * value);
				sc_boolean TRANSFER_AUDIO_TO_HF_raised;
				pmcore::PmCoreIfMessage_TransferAudioRequest * TRANSFER_AUDIO_TO_HF_value;
				/*! Raises the in event 'MUTE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_mUTE_RINGTONE(pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest * value);
				sc_boolean MUTE_RINGTONE_raised;
				pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest * MUTE_RINGTONE_value;
				/*! Raises the in event 'START_WAITING_MODE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sTART_WAITING_MODE();
				sc_boolean START_WAITING_MODE_raised;
				/*! Raises the in event 'STOP_WAITING_MODE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sTOP_WAITING_MODE();
				sc_boolean STOP_WAITING_MODE_raised;
				/*! Raises the in event 'ACCEPT_CALL_BY_ACQUIRING_CH' that is defined in the interface scope 'UserAction'. */
				void internal_raise_aCCEPT_CALL_BY_ACQUIRING_CH(pmcore::PmCoreIfMessage_AcceptCallRequest * value);
				sc_boolean ACCEPT_CALL_BY_ACQUIRING_CH_raised;
				pmcore::PmCoreIfMessage_AcceptCallRequest * ACCEPT_CALL_BY_ACQUIRING_CH_value;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for UserAction interface scope operation callbacks.
				class SCI_UserAction_OCB
				{
					public:
						virtual ~SCI_UserAction_OCB() = 0;
						
						virtual void dial(pmcore::PmCoreIfMessage_DialRequest * msg) = 0;
						
						virtual void acquirePhoneAudio(pmcore::PmCoreIfMessage_AcceptCallRequest * msg) = 0;
						
						virtual void speedDial(pmcore::PmCoreIfMessage_SpeedDialRequest * msg) = 0;
						
						virtual void reDial(pmcore::PmCoreIfMessage_RedialRequest * msg) = 0;
						
						virtual void hangupCalls(pmcore::PmCoreIfMessage_HangupCallsRequest * msg) = 0;
						
						virtual void hangupAllCalls(pmcore::PmCoreIfMessage_HangupCallsRequest * msg) = 0;
						
						virtual void swapCalls(pmcore::PmCoreIfMessage_SwapCallRequest * msg) = 0;
						
						virtual void splitCalls(pmcore::PmCoreIfMessage_SplitCallsRequest * msg) = 0;
						
						virtual void conference(pmcore::PmCoreIfMessage_MergeCallsRequest * msg) = 0;
						
						virtual void transferAudio(pmcore::PmCoreIfMessage_TransferAudioRequest * msg) = 0;
						
						virtual void muteRingtone(pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest * msg) = 0;
						
						virtual void postTransferAudio(sc_string audio) = 0;
						
						virtual void postAcceptCall() = 0;
						
						virtual void postHoldAndAcceptCall() = 0;
						
						virtual void postCancelOutgoing() = 0;
						
						virtual void setTransferAudioToHfToSuccess(pmcore::PmCoreIfMessage_TransferAudioRequest * msg) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_UserAction_OCB'. */
				void setSCI_UserAction_OCB(SCI_UserAction_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_UserAction'. */
		SCI_UserAction* getSCI_UserAction();
		
		//! Inner class for AgCallStateUpdate interface scope.
		class SCI_AgCallStateUpdate
		{
			public:
				SCI_AgCallStateUpdate(PmCallStateHandlerSm * parent):
					IDLE_raised(false),
					INCOMING_raised(false),
					INCOMING_INBAND_raised(false),
					DIALING_raised(false),
					HELD_raised(false),
					ACTIVE_raised(false),
					CALL_DISCONNECTING_raised(false),
					CALL_DISCONNECTED_raised(false),
					CALL_X_DIALING_raised(false),
					CALL_X_WAITING_raised(false),
					CALLS_SWAPPABLE_raised(false),
					CALLS_CONFERENCE_raised(false),
					ALL_CALLS_DISCONNECTED_raised(false),
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'callCount' that is defined in the interface scope 'AgCallStateUpdate'. */
				CallCount get_callCount() const;
				
				/*! Sets the value of the variable 'callCount' that is defined in the interface scope 'AgCallStateUpdate'. */
				void set_callCount(CallCount value);
				
				
				/*! Raises the in event 'IDLE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_iDLE();
				
				
				/*! Raises the in event 'INCOMING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_iNCOMING();
				
				
				/*! Raises the in event 'INCOMING_INBAND' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_iNCOMING_INBAND();
				
				
				/*! Raises the in event 'DIALING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_dIALING();
				
				
				/*! Raises the in event 'HELD' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_hELD();
				
				
				/*! Raises the in event 'ACTIVE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_aCTIVE();
				
				
				/*! Raises the in event 'CALL_DISCONNECTING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_cALL_DISCONNECTING();
				
				
				/*! Raises the in event 'CALL_DISCONNECTED' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_cALL_DISCONNECTED();
				
				
				/*! Raises the in event 'CALL_X_DIALING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_cALL_X_DIALING();
				
				
				/*! Raises the in event 'CALL_X_WAITING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_cALL_X_WAITING();
				
				
				/*! Raises the in event 'CALLS_SWAPPABLE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_cALLS_SWAPPABLE();
				
				
				/*! Raises the in event 'CALLS_CONFERENCE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_cALLS_CONFERENCE();
				
				
				/*! Raises the in event 'ALL_CALLS_DISCONNECTED' that is defined in the interface scope 'AgCallStateUpdate'. */
				void raise_aLL_CALLS_DISCONNECTED();
				
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				CallCount callCount;
				/*! Raises the in event 'IDLE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_iDLE();
				sc_boolean IDLE_raised;
				/*! Raises the in event 'INCOMING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_iNCOMING();
				sc_boolean INCOMING_raised;
				/*! Raises the in event 'INCOMING_INBAND' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_iNCOMING_INBAND();
				sc_boolean INCOMING_INBAND_raised;
				/*! Raises the in event 'DIALING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_dIALING();
				sc_boolean DIALING_raised;
				/*! Raises the in event 'HELD' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_hELD();
				sc_boolean HELD_raised;
				/*! Raises the in event 'ACTIVE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_aCTIVE();
				sc_boolean ACTIVE_raised;
				/*! Raises the in event 'CALL_DISCONNECTING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_cALL_DISCONNECTING();
				sc_boolean CALL_DISCONNECTING_raised;
				/*! Raises the in event 'CALL_DISCONNECTED' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_cALL_DISCONNECTED();
				sc_boolean CALL_DISCONNECTED_raised;
				/*! Raises the in event 'CALL_X_DIALING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_cALL_X_DIALING();
				sc_boolean CALL_X_DIALING_raised;
				/*! Raises the in event 'CALL_X_WAITING' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_cALL_X_WAITING();
				sc_boolean CALL_X_WAITING_raised;
				/*! Raises the in event 'CALLS_SWAPPABLE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_cALLS_SWAPPABLE();
				sc_boolean CALLS_SWAPPABLE_raised;
				/*! Raises the in event 'CALLS_CONFERENCE' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_cALLS_CONFERENCE();
				sc_boolean CALLS_CONFERENCE_raised;
				/*! Raises the in event 'ALL_CALLS_DISCONNECTED' that is defined in the interface scope 'AgCallStateUpdate'. */
				void internal_raise_aLL_CALLS_DISCONNECTED();
				sc_boolean ALL_CALLS_DISCONNECTED_raised;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for AgCallStateUpdate interface scope operation callbacks.
				class SCI_AgCallStateUpdate_OCB
				{
					public:
						virtual ~SCI_AgCallStateUpdate_OCB() = 0;
						
						virtual void waitingCall() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AgCallStateUpdate_OCB'. */
				void setSCI_AgCallStateUpdate_OCB(SCI_AgCallStateUpdate_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AgCallStateUpdate'. */
		SCI_AgCallStateUpdate* getSCI_AgCallStateUpdate();
		
		//! Inner class for AgAudioUpdate interface scope.
		class SCI_AgAudioUpdate
		{
			public:
				SCI_AgAudioUpdate(PmCallStateHandlerSm * parent):
					SCO_CONNECTED_raised(false),
					SCO_CONNECTED_value(),
					SCO_PAUSED_raised(false),
					SCO_PAUSED_value(),
					SCO_DISCONNECTED_raised(false),
					SCO_DISCONNECTED_value(),
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'scoStatus' that is defined in the interface scope 'AgAudioUpdate'. */
				SCOStatus get_scoStatus() const;
				
				/*! Sets the value of the variable 'scoStatus' that is defined in the interface scope 'AgAudioUpdate'. */
				void set_scoStatus(SCOStatus value);
				
				
				/*! Raises the in event 'SCO_CONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void raise_sCO_CONNECTED(SCOStatus value);
				
				
				/*! Raises the in event 'SCO_PAUSED' that is defined in the interface scope 'AgAudioUpdate'. */
				void raise_sCO_PAUSED(SCOStatus value);
				
				
				/*! Raises the in event 'SCO_DISCONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void raise_sCO_DISCONNECTED(SCOStatus value);
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				SCOStatus scoStatus;
				/*! Raises the in event 'SCO_CONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void internal_raise_sCO_CONNECTED(SCOStatus value);
				sc_boolean SCO_CONNECTED_raised;
				SCOStatus SCO_CONNECTED_value;
				/*! Raises the in event 'SCO_PAUSED' that is defined in the interface scope 'AgAudioUpdate'. */
				void internal_raise_sCO_PAUSED(SCOStatus value);
				sc_boolean SCO_PAUSED_raised;
				SCOStatus SCO_PAUSED_value;
				/*! Raises the in event 'SCO_DISCONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void internal_raise_sCO_DISCONNECTED(SCOStatus value);
				sc_boolean SCO_DISCONNECTED_raised;
				SCOStatus SCO_DISCONNECTED_value;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AgAudioUpdate'. */
		SCI_AgAudioUpdate* getSCI_AgAudioUpdate();
		
		//! Inner class for SmHandler interface scope.
		class SCI_SmHandler
		{
			public:
				SCI_SmHandler(PmCallStateHandlerSm * parent):
					SWITCH_TO_PASSIVE_raised(false),
					SWITCH_TO_ACTIVE_raised(false),
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'isActiveDevice' that is defined in the interface scope 'SmHandler'. */
				sc_boolean get_isActiveDevice() const;
				
				/*! Sets the value of the variable 'isActiveDevice' that is defined in the interface scope 'SmHandler'. */
				void set_isActiveDevice(sc_boolean value);
				
				
				/*! Raises the in event 'SWITCH_TO_PASSIVE' that is defined in the interface scope 'SmHandler'. */
				void raise_sWITCH_TO_PASSIVE();
				
				
				/*! Raises the in event 'SWITCH_TO_ACTIVE' that is defined in the interface scope 'SmHandler'. */
				void raise_sWITCH_TO_ACTIVE();
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				sc_boolean isActiveDevice;
				/*! Raises the in event 'SWITCH_TO_PASSIVE' that is defined in the interface scope 'SmHandler'. */
				void internal_raise_sWITCH_TO_PASSIVE();
				sc_boolean SWITCH_TO_PASSIVE_raised;
				/*! Raises the in event 'SWITCH_TO_ACTIVE' that is defined in the interface scope 'SmHandler'. */
				void internal_raise_sWITCH_TO_ACTIVE();
				sc_boolean SWITCH_TO_ACTIVE_raised;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for SmHandler interface scope operation callbacks.
				class SCI_SmHandler_OCB
				{
					public:
						virtual ~SCI_SmHandler_OCB() = 0;
						
						virtual void stopSm() = 0;
						
						virtual void enterIdle() = 0;
						
						virtual void updatePhoneCallAudioActive(sc_boolean audioActive) = 0;
						
						virtual void updateCallStatus() = 0;
						
						virtual void updateVehicleAudioStastus() = 0;
						
						virtual void callDisconnected() = 0;
						
						virtual void updateWaitingModeState(WaitingModeStateEnumType waitingModeState) = 0;
						
						virtual void acceptWaitingModeCall() = 0;
						
						virtual void holdAndAcceptWaitingModeCall() = 0;
						
						virtual void postSwitchToPassiveResponse(PmResultMessage result) = 0;
						
						virtual StopAudioStateEnumType isStopAudioRequested() = 0;
						
						virtual sc_boolean isRingtoneSuppressed() = 0;
						
						virtual sc_boolean isInbandRinging() = 0;
						
						virtual void traceMessage(sc_string trace) = 0;
						
						virtual void generateCallStateEvent() = 0;
						
						virtual void acceptCallFinished() = 0;
						
						virtual void handleSwitchToActiveInOutbandRinging() = 0;
						
						virtual void processAllCallsRemoved() = 0;
						
						virtual sc_boolean isChannelDenied() = 0;
						
						virtual void setAcceptCallParam(pmcore::PmCoreIfMessage_AcceptCallRequest * msg) = 0;
						
						virtual pmcore::PmCoreIfMessage_AcceptCallRequest * getAcceptCallParam() = 0;
						
						virtual void printPhoneAudioState(PmCorePhoneAudioState audioState) = 0;
						
						virtual void updateErrorStatus(SmErrorEnumType errorInfo) = 0;
						
						virtual void updateCallErrorStatus(pmcore::PmCoreIfMessage * msg, SmErrorEnumType errorInfo) = 0;
						
						virtual void handleSCODisconnection() = 0;
						
						virtual void startSCOTimer() = 0;
						
						virtual void stopSCOTimer() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_SmHandler_OCB'. */
				void setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_SmHandler'. */
		SCI_SmHandler* getSCI_SmHandler();
		
		//! Inner class for AudioManagerRequest interface scope.
		class SCI_AudioManagerRequest
		{
			public:
				SCI_AudioManagerRequest(PmCallStateHandlerSm * parent):
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'phoneAudioState' that is defined in the interface scope 'AudioManagerRequest'. */
				PmCorePhoneAudioState get_phoneAudioState() const;
				
				/*! Sets the value of the variable 'phoneAudioState' that is defined in the interface scope 'AudioManagerRequest'. */
				void set_phoneAudioState(PmCorePhoneAudioState value);
				
				
				
				
				
				
				
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				PmCorePhoneAudioState phoneAudioState;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioManagerRequest interface scope operation callbacks.
				class SCI_AudioManagerRequest_OCB
				{
					public:
						virtual ~SCI_AudioManagerRequest_OCB() = 0;
						
						virtual void requestPhoneAudio() = 0;
						
						virtual void requestWaitingModeAudio() = 0;
						
						virtual void playHfAudio(SCOStatus scoStatus) = 0;
						
						virtual void playRingtone() = 0;
						
						virtual void playWaitingModeTone(SCOStatus scoStatus) = 0;
						
						virtual void pauseHfAudio() = 0;
						
						virtual void stopAudio() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioManagerRequest_OCB'. */
				void setSCI_AudioManagerRequest_OCB(SCI_AudioManagerRequest_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioManagerRequest'. */
		SCI_AudioManagerRequest* getSCI_AudioManagerRequest();
		
		//! Inner class for AudioManagerResponse interface scope.
		class SCI_AudioManagerResponse
		{
			public:
				SCI_AudioManagerResponse(PmCallStateHandlerSm * parent):
					RINGTONE_CHANNEL_GRANTED_raised(false),
					RINGTONE_CHANNEL_DENIED_raised(false),
					PHONE_CHANNEL_GRANTED_raised(false),
					PHONE_CHANNEL_DENIED_raised(false),
					WAITINGMODE_CHANNEL_GRANTED_raised(false),
					WAITINGMODE_CHANNEL_DENIED_raised(false),
					PLAY_AUDIO_SUCCESS_raised(false),
					PLAY_AUDIO_FAILURE_raised(false),
					PAUSE_AUDIO_SUCCESS_raised(false),
					PAUSE_AUDIO_FAILURE_raised(false),
					STOP_AUDIO_SUCCESS_raised(false),
					STOP_AUDIO_FAILURE_raised(false),
					PHONE_CHANNEL_RELEASED_raised(false),
					RINGTONE_CHANNEL_RELEASED_raised(false),
					WAITINGMODE_CHANNEL_RELEASED_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'RINGTONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_rINGTONE_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'RINGTONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_rINGTONE_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'PHONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pHONE_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'PHONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pHONE_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'WAITINGMODE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_wAITINGMODE_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'WAITINGMODE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_wAITINGMODE_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'PLAY_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pLAY_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'PLAY_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pLAY_AUDIO_FAILURE();
				
				
				/*! Raises the in event 'PAUSE_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pAUSE_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'PAUSE_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pAUSE_AUDIO_FAILURE();
				
				
				/*! Raises the in event 'STOP_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_sTOP_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'STOP_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_sTOP_AUDIO_FAILURE();
				
				
				/*! Raises the in event 'PHONE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pHONE_CHANNEL_RELEASED();
				
				
				/*! Raises the in event 'RINGTONE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_rINGTONE_CHANNEL_RELEASED();
				
				
				/*! Raises the in event 'WAITINGMODE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_wAITINGMODE_CHANNEL_RELEASED();
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				/*! Raises the in event 'RINGTONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_rINGTONE_CHANNEL_GRANTED();
				sc_boolean RINGTONE_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'RINGTONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_rINGTONE_CHANNEL_DENIED();
				sc_boolean RINGTONE_CHANNEL_DENIED_raised;
				/*! Raises the in event 'PHONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pHONE_CHANNEL_GRANTED();
				sc_boolean PHONE_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'PHONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pHONE_CHANNEL_DENIED();
				sc_boolean PHONE_CHANNEL_DENIED_raised;
				/*! Raises the in event 'WAITINGMODE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_wAITINGMODE_CHANNEL_GRANTED();
				sc_boolean WAITINGMODE_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'WAITINGMODE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_wAITINGMODE_CHANNEL_DENIED();
				sc_boolean WAITINGMODE_CHANNEL_DENIED_raised;
				/*! Raises the in event 'PLAY_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pLAY_AUDIO_SUCCESS();
				sc_boolean PLAY_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'PLAY_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pLAY_AUDIO_FAILURE();
				sc_boolean PLAY_AUDIO_FAILURE_raised;
				/*! Raises the in event 'PAUSE_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pAUSE_AUDIO_SUCCESS();
				sc_boolean PAUSE_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'PAUSE_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pAUSE_AUDIO_FAILURE();
				sc_boolean PAUSE_AUDIO_FAILURE_raised;
				/*! Raises the in event 'STOP_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_sTOP_AUDIO_SUCCESS();
				sc_boolean STOP_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'STOP_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_sTOP_AUDIO_FAILURE();
				sc_boolean STOP_AUDIO_FAILURE_raised;
				/*! Raises the in event 'PHONE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pHONE_CHANNEL_RELEASED();
				sc_boolean PHONE_CHANNEL_RELEASED_raised;
				/*! Raises the in event 'RINGTONE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_rINGTONE_CHANNEL_RELEASED();
				sc_boolean RINGTONE_CHANNEL_RELEASED_raised;
				/*! Raises the in event 'WAITINGMODE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_wAITINGMODE_CHANNEL_RELEASED();
				sc_boolean WAITINGMODE_CHANNEL_RELEASED_raised;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioManagerResponse'. */
		SCI_AudioManagerResponse* getSCI_AudioManagerResponse();
		
		//! Inner class for AgResponse interface scope.
		class SCI_AgResponse
		{
			public:
				SCI_AgResponse(PmCallStateHandlerSm * parent):
					ACCEPT_OK_raised(false),
					DIAL_OK_raised(false),
					HOLD_INCOMING_OK_raised(false),
					HANGUP_OK_raised(false),
					CONF_OK_raised(false),
					SWAP_OK_raised(false),
					SPLIT_OK_raised(false),
					SPEED_DIAL_OK_raised(false),
					ACCEPT_SCO_CONNECT_OK_raised(false),
					GET_CALLS_OK_raised(false),
					REDIAL_OK_raised(false),
					TRANSFER_OK_raised(false),
					RELEASE_AND_ACCEPT_OK_raised(false),
					RELEASE_AND_SWAP_OK_raised(false),
					HOLD_AND_ACCEPT_OK_raised(false),
					HANGUP_ALL_OK_raised(false),
					HANGUP_MULTIPARTY_OK_raised(false),
					SEND_DTMF_OK_raised(false),
					DEFAULT_ERROR_raised(false),
					ACCEPT_ERROR_raised(false),
					ACCEPT_ERROR_value(),
					DIAL_ERROR_raised(false),
					DIAL_ERROR_value(),
					HOLD_INCOMING_ERROR_raised(false),
					HOLD_INCOMING_ERROR_value(),
					SPEED_DIAL_ERROR_raised(false),
					SPEED_DIAL_ERROR_value(),
					ACCEPT_SCO_CONNECT_ERROR_raised(false),
					ACCEPT_SCO_CONNECT_ERROR_value(),
					GET_CALLS_ERROR_raised(false),
					GET_CALLS_ERROR_value(),
					REDIAL_ERROR_raised(false),
					REDIAL_ERROR_value(),
					TRANSFER_ERROR_raised(false),
					TRANSFER_ERROR_value(),
					RELEASE_AND_ACCEPT_ERROR_raised(false),
					RELEASE_AND_ACCEPT_ERROR_value(),
					RELEASE_AND_SWAP_ERROR_raised(false),
					RELEASE_AND_SWAP_ERROR_value(),
					HOLD_AND_ACCEPT_ERROR_raised(false),
					HOLD_AND_ACCEPT_ERROR_value(),
					SEND_DTMF_ERROR_raised(false),
					SEND_DTMF_ERROR_value(),
					parent(parent)
				{}
				
				/*! Raises the in event 'ACCEPT_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_aCCEPT_OK();
				
				
				/*! Raises the in event 'DIAL_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_dIAL_OK();
				
				
				/*! Raises the in event 'HOLD_INCOMING_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_hOLD_INCOMING_OK();
				
				
				/*! Raises the in event 'HANGUP_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_hANGUP_OK();
				
				
				/*! Raises the in event 'CONF_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_cONF_OK();
				
				
				/*! Raises the in event 'SWAP_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_sWAP_OK();
				
				
				/*! Raises the in event 'SPLIT_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_sPLIT_OK();
				
				
				/*! Raises the in event 'SPEED_DIAL_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_sPEED_DIAL_OK();
				
				
				/*! Raises the in event 'ACCEPT_SCO_CONNECT_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_aCCEPT_SCO_CONNECT_OK();
				
				
				/*! Raises the in event 'GET_CALLS_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_gET_CALLS_OK();
				
				
				/*! Raises the in event 'REDIAL_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_rEDIAL_OK();
				
				
				/*! Raises the in event 'TRANSFER_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_tRANSFER_OK();
				
				
				/*! Raises the in event 'RELEASE_AND_ACCEPT_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_rELEASE_AND_ACCEPT_OK();
				
				
				/*! Raises the in event 'RELEASE_AND_SWAP_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_rELEASE_AND_SWAP_OK();
				
				
				/*! Raises the in event 'HOLD_AND_ACCEPT_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_hOLD_AND_ACCEPT_OK();
				
				
				/*! Raises the in event 'HANGUP_ALL_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_hANGUP_ALL_OK();
				
				
				/*! Raises the in event 'HANGUP_MULTIPARTY_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_hANGUP_MULTIPARTY_OK();
				
				
				/*! Raises the in event 'SEND_DTMF_OK' that is defined in the interface scope 'AgResponse'. */
				void raise_sEND_DTMF_OK();
				
				
				/*! Raises the in event 'DEFAULT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_dEFAULT_ERROR();
				
				
				/*! Raises the in event 'ACCEPT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_aCCEPT_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'DIAL_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_dIAL_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'HOLD_INCOMING_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_hOLD_INCOMING_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'SPEED_DIAL_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_sPEED_DIAL_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'ACCEPT_SCO_CONNECT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_aCCEPT_SCO_CONNECT_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'GET_CALLS_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_gET_CALLS_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'REDIAL_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_rEDIAL_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'TRANSFER_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_tRANSFER_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'RELEASE_AND_ACCEPT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_rELEASE_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'RELEASE_AND_SWAP_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_rELEASE_AND_SWAP_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'HOLD_AND_ACCEPT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_hOLD_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				/*! Raises the in event 'SEND_DTMF_ERROR' that is defined in the interface scope 'AgResponse'. */
				void raise_sEND_DTMF_ERROR(pmcore::PmCoreIfMessage * value);
				
				
				
				
				
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				/*! Raises the in event 'ACCEPT_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_aCCEPT_OK();
				sc_boolean ACCEPT_OK_raised;
				/*! Raises the in event 'DIAL_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_dIAL_OK();
				sc_boolean DIAL_OK_raised;
				/*! Raises the in event 'HOLD_INCOMING_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_hOLD_INCOMING_OK();
				sc_boolean HOLD_INCOMING_OK_raised;
				/*! Raises the in event 'HANGUP_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_hANGUP_OK();
				sc_boolean HANGUP_OK_raised;
				/*! Raises the in event 'CONF_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_cONF_OK();
				sc_boolean CONF_OK_raised;
				/*! Raises the in event 'SWAP_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_sWAP_OK();
				sc_boolean SWAP_OK_raised;
				/*! Raises the in event 'SPLIT_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_sPLIT_OK();
				sc_boolean SPLIT_OK_raised;
				/*! Raises the in event 'SPEED_DIAL_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_sPEED_DIAL_OK();
				sc_boolean SPEED_DIAL_OK_raised;
				/*! Raises the in event 'ACCEPT_SCO_CONNECT_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_aCCEPT_SCO_CONNECT_OK();
				sc_boolean ACCEPT_SCO_CONNECT_OK_raised;
				/*! Raises the in event 'GET_CALLS_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_gET_CALLS_OK();
				sc_boolean GET_CALLS_OK_raised;
				/*! Raises the in event 'REDIAL_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_rEDIAL_OK();
				sc_boolean REDIAL_OK_raised;
				/*! Raises the in event 'TRANSFER_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_tRANSFER_OK();
				sc_boolean TRANSFER_OK_raised;
				/*! Raises the in event 'RELEASE_AND_ACCEPT_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_rELEASE_AND_ACCEPT_OK();
				sc_boolean RELEASE_AND_ACCEPT_OK_raised;
				/*! Raises the in event 'RELEASE_AND_SWAP_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_rELEASE_AND_SWAP_OK();
				sc_boolean RELEASE_AND_SWAP_OK_raised;
				/*! Raises the in event 'HOLD_AND_ACCEPT_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_hOLD_AND_ACCEPT_OK();
				sc_boolean HOLD_AND_ACCEPT_OK_raised;
				/*! Raises the in event 'HANGUP_ALL_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_hANGUP_ALL_OK();
				sc_boolean HANGUP_ALL_OK_raised;
				/*! Raises the in event 'HANGUP_MULTIPARTY_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_hANGUP_MULTIPARTY_OK();
				sc_boolean HANGUP_MULTIPARTY_OK_raised;
				/*! Raises the in event 'SEND_DTMF_OK' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_sEND_DTMF_OK();
				sc_boolean SEND_DTMF_OK_raised;
				/*! Raises the in event 'DEFAULT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_dEFAULT_ERROR();
				sc_boolean DEFAULT_ERROR_raised;
				/*! Raises the in event 'ACCEPT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_aCCEPT_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean ACCEPT_ERROR_raised;
				pmcore::PmCoreIfMessage * ACCEPT_ERROR_value;
				/*! Raises the in event 'DIAL_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_dIAL_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean DIAL_ERROR_raised;
				pmcore::PmCoreIfMessage * DIAL_ERROR_value;
				/*! Raises the in event 'HOLD_INCOMING_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_hOLD_INCOMING_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean HOLD_INCOMING_ERROR_raised;
				pmcore::PmCoreIfMessage * HOLD_INCOMING_ERROR_value;
				/*! Raises the in event 'SPEED_DIAL_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_sPEED_DIAL_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean SPEED_DIAL_ERROR_raised;
				pmcore::PmCoreIfMessage * SPEED_DIAL_ERROR_value;
				/*! Raises the in event 'ACCEPT_SCO_CONNECT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_aCCEPT_SCO_CONNECT_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean ACCEPT_SCO_CONNECT_ERROR_raised;
				pmcore::PmCoreIfMessage * ACCEPT_SCO_CONNECT_ERROR_value;
				/*! Raises the in event 'GET_CALLS_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_gET_CALLS_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean GET_CALLS_ERROR_raised;
				pmcore::PmCoreIfMessage * GET_CALLS_ERROR_value;
				/*! Raises the in event 'REDIAL_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_rEDIAL_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean REDIAL_ERROR_raised;
				pmcore::PmCoreIfMessage * REDIAL_ERROR_value;
				/*! Raises the in event 'TRANSFER_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_tRANSFER_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean TRANSFER_ERROR_raised;
				pmcore::PmCoreIfMessage * TRANSFER_ERROR_value;
				/*! Raises the in event 'RELEASE_AND_ACCEPT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_rELEASE_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean RELEASE_AND_ACCEPT_ERROR_raised;
				pmcore::PmCoreIfMessage * RELEASE_AND_ACCEPT_ERROR_value;
				/*! Raises the in event 'RELEASE_AND_SWAP_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_rELEASE_AND_SWAP_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean RELEASE_AND_SWAP_ERROR_raised;
				pmcore::PmCoreIfMessage * RELEASE_AND_SWAP_ERROR_value;
				/*! Raises the in event 'HOLD_AND_ACCEPT_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_hOLD_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean HOLD_AND_ACCEPT_ERROR_raised;
				pmcore::PmCoreIfMessage * HOLD_AND_ACCEPT_ERROR_value;
				/*! Raises the in event 'SEND_DTMF_ERROR' that is defined in the interface scope 'AgResponse'. */
				void internal_raise_sEND_DTMF_ERROR(pmcore::PmCoreIfMessage * value);
				sc_boolean SEND_DTMF_ERROR_raised;
				pmcore::PmCoreIfMessage * SEND_DTMF_ERROR_value;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for AgResponse interface scope operation callbacks.
				class SCI_AgResponse_OCB
				{
					public:
						virtual ~SCI_AgResponse_OCB() = 0;
						
						virtual void acceptError() = 0;
						
						virtual void dialError() = 0;
						
						virtual void swapError() = 0;
						
						virtual void hangupError() = 0;
						
						virtual void transferError() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AgResponse_OCB'. */
				void setSCI_AgResponse_OCB(SCI_AgResponse_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AgResponse'. */
		SCI_AgResponse* getSCI_AgResponse();
		
		//! Inner class for TimerUpdate interface scope.
		class SCI_TimerUpdate
		{
			public:
				SCI_TimerUpdate(PmCallStateHandlerSm * parent):
					TIMER_CALLBACK_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'TIMER_CALLBACK' that is defined in the interface scope 'TimerUpdate'. */
				void raise_tIMER_CALLBACK();
				
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				/*! Raises the in event 'TIMER_CALLBACK' that is defined in the interface scope 'TimerUpdate'. */
				void internal_raise_tIMER_CALLBACK();
				sc_boolean TIMER_CALLBACK_raised;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for TimerUpdate interface scope operation callbacks.
				class SCI_TimerUpdate_OCB
				{
					public:
						virtual ~SCI_TimerUpdate_OCB() = 0;
						
						virtual void handleTimerCallback() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_TimerUpdate_OCB'. */
				void setSCI_TimerUpdate_OCB(SCI_TimerUpdate_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_TimerUpdate'. */
		SCI_TimerUpdate* getSCI_TimerUpdate();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<PmCallStateHandlerSmStates>* tracingcallback);
		
		ysc::TraceObserver<PmCallStateHandlerSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(PmCallStateHandlerSmStates state) const;
		
		
		
	protected:
		
		
	private:
		PmCallStateHandlerSm(const PmCallStateHandlerSm &rhs);
		PmCallStateHandlerSm& operator=(const PmCallStateHandlerSm&);
		
		//! Inner class for internal interface scope.
		class InternalSCI
		{
			public:
				InternalSCI(PmCallStateHandlerSm * parent):
					CHECK_AUDIO_raised(false),
					GENERATE_CALL_STATE_EVENT_raised(false),
					TO_START_WAITING_MODE_raised(false),
					MOVE_TO_NEXT_STATE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'CHECK_AUDIO' that is defined in the internal scope. */
				void raise_cHECK_AUDIO();
				
				/*! Checks if the out event 'CHECK_AUDIO' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_cHECK_AUDIO() const;
				
				
				/*! Raises the in event 'GENERATE_CALL_STATE_EVENT' that is defined in the internal scope. */
				void raise_gENERATE_CALL_STATE_EVENT();
				
				/*! Checks if the out event 'GENERATE_CALL_STATE_EVENT' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_gENERATE_CALL_STATE_EVENT() const;
				
				
				/*! Raises the in event 'TO_START_WAITING_MODE' that is defined in the internal scope. */
				void raise_tO_START_WAITING_MODE();
				
				/*! Checks if the out event 'TO_START_WAITING_MODE' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_tO_START_WAITING_MODE() const;
				
				
				/*! Raises the in event 'MOVE_TO_NEXT_STATE' that is defined in the internal scope. */
				void raise_mOVE_TO_NEXT_STATE();
				
				/*! Checks if the out event 'MOVE_TO_NEXT_STATE' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_mOVE_TO_NEXT_STATE() const;
				
				
				
			private:
				friend class PmCallStateHandlerSm;
				/*! Raises the in event 'CHECK_AUDIO' that is defined in the internal scope. */
				void internal_raise_cHECK_AUDIO();
				sc_boolean CHECK_AUDIO_raised;
				/*! Raises the in event 'GENERATE_CALL_STATE_EVENT' that is defined in the internal scope. */
				void internal_raise_gENERATE_CALL_STATE_EVENT();
				sc_boolean GENERATE_CALL_STATE_EVENT_raised;
				/*! Raises the in event 'TO_START_WAITING_MODE' that is defined in the internal scope. */
				void internal_raise_tO_START_WAITING_MODE();
				sc_boolean TO_START_WAITING_MODE_raised;
				/*! Raises the in event 'MOVE_TO_NEXT_STATE' that is defined in the internal scope. */
				void internal_raise_mOVE_TO_NEXT_STATE();
				sc_boolean MOVE_TO_NEXT_STATE_raised;
				PmCallStateHandlerSm * parent;
				void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
				
				
		};
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 1;
		
		
		ysc::TraceObserver<PmCallStateHandlerSmStates>* ifaceTraceObserver;
		
		PmCallStateHandlerSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_UserAction ifaceUserAction;
		SCI_UserAction_OCB* ifaceUserAction_OCB;
		SCI_AgCallStateUpdate ifaceAgCallStateUpdate;
		SCI_AgCallStateUpdate_OCB* ifaceAgCallStateUpdate_OCB;
		SCI_AgAudioUpdate ifaceAgAudioUpdate;
		SCI_SmHandler ifaceSmHandler;
		SCI_SmHandler_OCB* ifaceSmHandler_OCB;
		SCI_AudioManagerRequest ifaceAudioManagerRequest;
		SCI_AudioManagerRequest_OCB* ifaceAudioManagerRequest_OCB;
		SCI_AudioManagerResponse ifaceAudioManagerResponse;
		SCI_AgResponse ifaceAgResponse;
		SCI_AgResponse_OCB* ifaceAgResponse_OCB;
		SCI_TimerUpdate ifaceTimerUpdate;
		SCI_TimerUpdate_OCB* ifaceTimerUpdate_OCB;
		InternalSCI ifaceInternalSCI;
		
		// prototypes of all internal functions
		
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr2_tr2();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr2_tr2();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr2_tr2();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr2_tr2();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr1_tr1();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr0_tr0();
		sc_boolean check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr3();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr4();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr5();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr6();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr7();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr8();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr3();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr4();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr5();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr6();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr3();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr4();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr3();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr4();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr5();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr6();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_tr4();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr2();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr1();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr0();
		void effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr1();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
		void enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
		void enact_Main_region_CallHandlerSm_CallHandler_region_Idle();
		void exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
		void exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_Entry_WaitForCallStateEventToStartwaitingMode();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_Entry_WaitForStopAudioResponse();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_TransferAudioToHFEntry();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_ReceivedActiveCallStatus();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_StartWaitingModeAfterAcceptResponse();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForActiveCallStatus();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForAudioChannelInband();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForAudioChannelOutband();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_EntryToWaitForChannelAllocation();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_EntryToInbandCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_Entry_ActiveCallStatus();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_EntryToNoRinging();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_EntryToNoRinging();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_DialedFromPhone();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_Accepting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_ActiveCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_AudioHandling();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_Ringing();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_XCallOutgoingOrWaiting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromAccepting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromActiveCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromAudioHandling();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromRinging();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromXCallOutgoingOrWaiting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_Entry_AcceptWaitingCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_Entry_HandlingHangup();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_Idle_default();
		void enseq_Main_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForStopAudioResponse();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForCallStateEventToStartwaitingMode();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_TransferAudioToHFEntry();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelOutband();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelInband();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForActiveCallStatus();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_ReceivedActiveCallStatus();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_StartWaitingModeAfterAcceptResponse();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_EntryToWaitForChannelAllocation();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_EntryToInbandCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Entry_ActiveCallStatus();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_EntryToNoRinging();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_EntryToNoRinging();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_DialedFromPhone();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_AudioHandling();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Ringing();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_ActiveCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_XCallOutgoingOrWaiting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Accepting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromXCallOutgoingOrWaiting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromRinging();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromActiveCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAccepting();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAudioHandling();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_default();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_HandlingHangup();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_AcceptWaitingCall();
		void enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_default();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
		void exseq_Main_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region();
		void exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForStopAudioResponse();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForCallStateEventToStartwaitingMode();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_TransferAudioToHFEntry();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelOutband();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_EntryToWaitForChannelAllocation();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelInband();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForActiveCallStatus();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_ReceivedActiveCallStatus();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_StartWaitingModeAfterAcceptResponse();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_EntryToInbandCall();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_EntryToNoRinging();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_EntryToNoRinging();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Entry_ActiveCallStatus();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_DialedFromPhone();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromXCallOutgoingOrWaiting();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromRinging();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromActiveCall();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAccepting();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_AudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Ringing();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_ActiveCall();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_XCallOutgoingOrWaiting();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Accepting();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_HandlingHangup();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_AcceptWaitingCall();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region__entry_Default();
		void react_Main_region__entry_Default();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_ToEntry();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromActive();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromXCallOutgoingOrWaiting();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_ReceivedActiveCallStatus_StartWaitingMode();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeAfterAcceptResponse();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeFromRinging();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_ExitToAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForActiveCallStatus();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_ReceivedActiveCallStatus();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelOutband();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToXCallWaitingOrOutgoing();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_MoveToIdle();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromActive();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromXCallOutgoingOrWaiting();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromAccepting();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_Exit_Idle();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_ExitToAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromRinging();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToIdle();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Exit_AudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_ExitToAudioHandling();
		void react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToIdleFromOutgoingCall();
		sc_boolean react();
		sc_boolean Main_region_CallHandlerSm_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall_react(const sc_boolean try_transition);
		sc_boolean Main_region_CallHandlerSm_CallHandler_region_Idle_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		std::deque<pmcallstatehandlersm_events::SctEvent*> internalEventQueue;
		pmcallstatehandlersm_events::SctEvent* getNextEvent();
		void dispatch_event(pmcallstatehandlersm_events::SctEvent * event);
		std::deque<pmcallstatehandlersm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline PmCallStateHandlerSm::SCI_UserAction_OCB::~SCI_UserAction_OCB() {}
inline PmCallStateHandlerSm::SCI_AgCallStateUpdate_OCB::~SCI_AgCallStateUpdate_OCB() {}
inline PmCallStateHandlerSm::SCI_SmHandler_OCB::~SCI_SmHandler_OCB() {}
inline PmCallStateHandlerSm::SCI_AudioManagerRequest_OCB::~SCI_AudioManagerRequest_OCB() {}
inline PmCallStateHandlerSm::SCI_AgResponse_OCB::~SCI_AgResponse_OCB() {}
inline PmCallStateHandlerSm::SCI_TimerUpdate_OCB::~SCI_TimerUpdate_OCB() {}


#endif /* PMCALLSTATEHANDLERSM_H_ */
