/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerRequestIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpVoiceCallManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpVoiceCallManagerRequestIf.h"
#include "IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::VoiceCallManager;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpVoiceCallManagerRequestIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::EvolutionGeniviDbusHfpVoiceCallManagerRequestIf()
{
   // _hfpVoiceCallManagerProxy is set later
   _callbackIf = nullptr;
}

EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::~EvolutionGeniviDbusHfpVoiceCallManagerRequestIf()
{
   _callbackIf = nullptr;
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::destroyProxy(void)
{
   ETG_TRACE_USR3(("destroyProxy(): VoiceCallManager"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpVoiceCallManagerProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("createRuntimeProxy(): VoiceCallManager: ObjPath: %s", objPath.c_str()));

   if(nullptr != _callbackIf)
   {
      if(false == _hfpVoiceCallManagerProxy.isInstanceAvailable(objPath))
      {
         ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
         ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
         ::ccdbusif::convertBusType2ConnectorOption(connectorOptions,
               parser.getInterface2BusType(::ccdbusif::evolution::IF_VOICE_CALL_MANAGER));

         ::boost::shared_ptr< VoiceCallManagerProxy > hfpVoiceCallManagerProxy = VoiceCallManagerProxy::createProxy(
               "pmAppEvoHfpVoiceCallManagerPort",
               parser.getInterface2BusName(::ccdbusif::evolution::IF_VOICE_CALL_MANAGER),
               objPath,
               connectorOptions,
               *this);

         _hfpVoiceCallManagerProxy.addProxyInstance(objPath, hfpVoiceCallManagerProxy);
      }
      else
      {
         ETG_TRACE_ERR(("VoiceCallManager Proxy already existing for requested ObjPath"));
      }
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("destroyRuntimeProxy(): VoiceCallManager: ObjPath: %s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally;
   //       therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration
   //       (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< VoiceCallManagerProxy > hfpVoiceCallManagerProxy;
   if(true == _hfpVoiceCallManagerProxy.isProxyAvailable(hfpVoiceCallManagerProxy, objPath))
   {
      hfpVoiceCallManagerProxy->sendDeregisterAll();
   }
   else
   {
      ETG_TRACE_ERR(("VoiceCallManager Proxy not exist for requested ObjPath"));
   }

   _hfpVoiceCallManagerProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::setCallbackIf(
      IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf* callbackIf)
{
   _callbackIf = callbackIf;

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if(nullptr != _callbackIf)
   {
      createRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::deviceRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if(nullptr != _callbackIf)
   {
      destroyRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::onAvailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onAvailable(): VoiceCallManager"));

   for(unsigned int i = 0; i < _hfpVoiceCallManagerProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< VoiceCallManagerProxy >& hfpVoiceCallManagerProxy = _hfpVoiceCallManagerProxy[i];
      if((nullptr != hfpVoiceCallManagerProxy.get()) && (proxy == hfpVoiceCallManagerProxy))
      {
         if(nullptr != _callbackIf)
         {
            hfpVoiceCallManagerProxy->sendCallAddedRegister(*_callbackIf);
            hfpVoiceCallManagerProxy->sendCallRemovedRegister(*_callbackIf);
            hfpVoiceCallManagerProxy->sendPropertyChangedRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpVoiceCallManagerProxy->getDBusObjectPath());

            //GetProperties
            sendGetPropertiesRequest(hfpVoiceCallManagerProxy->getDBusObjectPath());

            //Send GetCalls Request to Stack
            sendGetCallsRequest(hfpVoiceCallManagerProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onUnavailable(): VoiceCallManager"));

   for(unsigned int i = 0; i < _hfpVoiceCallManagerProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< VoiceCallManagerProxy >& hfpVoiceCallManagerProxy = _hfpVoiceCallManagerProxy[i];
      if((nullptr != hfpVoiceCallManagerProxy.get()) && (proxy == hfpVoiceCallManagerProxy))
      {
         hfpVoiceCallManagerProxy->sendDeregisterAll();

         if(nullptr != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpVoiceCallManagerProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendGetCallsRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendGetCallsRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendDialRequest(const ::std::string& objPath,
      const ::std::string& number, const ::std::string& hide_callerid)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendDialRequest(*_callbackIf, number, hide_callerid);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendMemDialRequest(const ::std::string& objPath,
      uint16 numberindex, const ::std::string& hide_callerid)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendMemDialRequest(*_callbackIf, numberindex, hide_callerid);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendRedialRequest(const ::std::string& objPath,
      const ::std::string& hide_callerid)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendRedialRequest(*_callbackIf, hide_callerid);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendSwapCallsRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendSwapCallsRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendReleaseAndAnswerRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendReleaseAndAnswerRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendReleaseAndSwapRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendReleaseAndSwapRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendHoldAndAnswerRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendHoldAndAnswerRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendHangupAllRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendHangupAllRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendPrivateChatRequest(const ::std::string& objPath,
      const ::std::string& call)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendPrivateChatRequest(*_callbackIf, call);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendCreateMultipartyRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendCreateMultipartyRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendHangupMultipartyRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendHangupMultipartyRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerRequestIf::sendSendTonesRequest(const ::std::string& objPath,
      const ::std::string& sendTones)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;

   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendSendTonesRequest(*_callbackIf, sendTones);
      }
   }

   return act;
}

} //evobtstackwrapper
