/**
 * @file EvolutionGeniviDbusHfpVoiceCallCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpVoiceCall
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpVoiceCallCallBackIf.h"
#include "IBtStackWrapper.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::VoiceCall;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpVoiceCallCallBackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpVoiceCallCallBackIf::EvolutionGeniviDbusHfpVoiceCallCallBackIf()
{
   _btStackWrapper = nullptr;
}

EvolutionGeniviDbusHfpVoiceCallCallBackIf::EvolutionGeniviDbusHfpVoiceCallCallBackIf(IBtStackWrapper* btStackWrapper)
{
   _btStackWrapper = btStackWrapper;
}

EvolutionGeniviDbusHfpVoiceCallCallBackIf::~EvolutionGeniviDbusHfpVoiceCallCallBackIf()
{
   _btStackWrapper = nullptr;
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onProxyAvailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onProxyUnavailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onGetPropertiesError(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   ETG_TRACE_USR4(("onGetPropertiesError(): VoiceCall"));

   (void)(proxy);
   (void)(error);

   //TODO: implement
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onGetPropertiesResponse(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   ETG_TRACE_USR4(("onGetPropertiesResponse(): VoiceCall"));

   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   BTSDbusPropertyList outPropertyList;

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("VoiceCall: ObjPath: %s", objPath.c_str()));

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_LINEIDENTIFICATION),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallLineIdentificationChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_NAME),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallNameChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_MULTIPARTY),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallMultipartyChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_STATE),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallStateChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_EMERGENCY),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallEmergencyChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_DIRECTION),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallDirectionChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_MODE),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallModeChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_TYPE),
         (int)::ccdbusif::evolution::IF_VOICE_CALL))
   {
      onVoiceCallTypeChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onHangupError(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHangupError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onHangupResponse(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHangupResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onAnswerError(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onAnswerError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onAnswerResponse(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onAnswerResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onHoldError(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHoldError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onHoldResponse(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHoldResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onPropertyChangedError(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onPropertyChangedError"));
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onPropertyChangedSignal(
      const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   ETG_TRACE_USR4(("onPropertyChangedSignal(): VoiceCall"));

   //check received properties for LineIdentification, Name, Multiparty, State, Emergency, Direction, Mode and Type
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   ::ccdbusif::evolution::HfpVoiceCallProperty propEnum = parser.getHfpVoiceCallProperty2Enum(signal->getName());

   BTSDbusPropertyList outPropertyList;
   parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getName(),
         (int)::ccdbusif::evolution::IF_VOICE_CALL);

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("VoiceCall: ObjPath: %s", objPath.c_str()));

   if(::ccdbusif::evolution::HFP_VOICE_CALL_LINEIDENTIFICATION == propEnum)
   {
      onVoiceCallLineIdentificationChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_VOICE_CALL_NAME == propEnum)
   {
      onVoiceCallNameChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_VOICE_CALL_MULTIPARTY == propEnum)
   {
      onVoiceCallMultipartyChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_VOICE_CALL_STATE == propEnum)
   {
      onVoiceCallStateChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_VOICE_CALL_EMERGENCY == propEnum)
   {
      onVoiceCallEmergencyChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_VOICE_CALL_DIRECTION == propEnum)
   {
      onVoiceCallDirectionChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_VOICE_CALL_MODE == propEnum)
   {
      onVoiceCallModeChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_VOICE_CALL_TYPE == propEnum)
   {
      onVoiceCallTypeChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallLineIdentificationChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: LineIdentification"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& lineIdentification = outProperty.propData.getString();

      ETG_TRACE_USR4(("VoiceCall: Value: %s", lineIdentification.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallLineIdentificationChanged(objPath, lineIdentification);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallLineIdentificationChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallNameChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: Name"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& name = outProperty.propData.getString();

      ETG_TRACE_USR4(("VoiceCall: Value: %s", name.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallNameChanged(objPath, name);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallNameChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallMultipartyChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: Multiparty"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const bool multiparty = outProperty.propData.getBool();

      ETG_TRACE_USR4(("VoiceCall: Value: %d", multiparty));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallMultipartyChanged(objPath, multiparty);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallMultipartyChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallStateChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: State"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& state = outProperty.propData.getString();

      ETG_TRACE_USR4(("VoiceCall: Value: %s", state.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallStateChanged(objPath, state);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallStateChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallEmergencyChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: Emergency"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const bool emergency = outProperty.propData.getBool();

      ETG_TRACE_USR4(("VoiceCall: Value: %d", emergency));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallEmergencyChanged(objPath, emergency);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallEmergencyChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallDirectionChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: Direction"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& direction = outProperty.propData.getString();

      ETG_TRACE_USR4(("VoiceCall: Value: %s", direction.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallDirectionChanged(objPath, direction);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallDirectionChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallModeChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: Mode"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& mode = outProperty.propData.getString();

      ETG_TRACE_USR4(("VoiceCall: Value: %s", mode.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallModeChanged(objPath, mode);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallModeChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallTypeChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCall: Property: Type"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& type = outProperty.propData.getString();

      ETG_TRACE_USR4(("VoiceCall: Value: %s", type.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceCallTypeChanged(objPath, type);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallCallBackIf::onVoiceCallTypeChanged:Property list size exceeds max limit"));
   }
}

} //evobtstackwrapper
