/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorProperties.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpNetworkOperator
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpNetworkOperatorProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpNetworkOperatorProperties::EvolutionGeniviDbusHfpNetworkOperatorProperties() :
   DbusProperties("NetworkOperator"),
   // properties
   _propertyStatus("Status"),
   _propertyName("Name")
{
   _string2EnumList[_propertyStatus] = (int)HFP_NETWORK_OPERATOR_STATUS;
   _string2EnumList[_propertyName] = (int)HFP_NETWORK_OPERATOR_NAME;

   _enum2StringList[(int)HFP_NETWORK_OPERATOR_STATUS] = &_propertyStatus;
   _enum2StringList[(int)HFP_NETWORK_OPERATOR_NAME] = &_propertyName;
}

EvolutionGeniviDbusHfpNetworkOperatorProperties::~EvolutionGeniviDbusHfpNetworkOperatorProperties()
{
}

HfpNetworkOperatorProperty EvolutionGeniviDbusHfpNetworkOperatorProperties::getProperty2Enum(
      const ::std::string& value) const
{
   return (HfpNetworkOperatorProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusHfpNetworkOperatorProperties::getProperty2String(
      const HfpNetworkOperatorProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpNetworkOperatorProperties::getProperty2StringTrace(
      const HfpNetworkOperatorProperty value) const
{
   if(HFP_NETWORK_OPERATOR_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
