/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpNetworkOperator
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpNetworkOperatorCallBackIf.h"
#include "IBtStackWrapper.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::NetworkOperator;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpNetworkOperatorCallBackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::EvolutionGeniviDbusHfpNetworkOperatorCallBackIf()
{
   _btStackWrapper = nullptr;
}

EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::EvolutionGeniviDbusHfpNetworkOperatorCallBackIf(
      IBtStackWrapper* btStackWrapper)
{
   _btStackWrapper = btStackWrapper;
}

EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::~EvolutionGeniviDbusHfpNetworkOperatorCallBackIf()
{
   _btStackWrapper = nullptr;
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onProxyAvailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onProxyUnavailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onGetPropertiesError(
      const ::boost::shared_ptr< NetworkOperatorProxy >& proxy,
      const ::boost::shared_ptr< GetPropertiesError >& error)
{
   ETG_TRACE_USR4(("onGetPropertiesError(): NetworkOperator"));

   (void)(proxy);
   (void)(error);

   //TODO: implement
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onGetPropertiesResponse(
      const ::boost::shared_ptr< NetworkOperatorProxy >& proxy,
      const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   ETG_TRACE_USR4(("onGetPropertiesResponse(): NetworkOperator"));

   //check received properties for Name and Status
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   BTSDbusPropertyList outPropertyList;

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("NetworkOperator: ObjPath: %s", objPath.c_str()));

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpNetworkOperatorProperty2String(::ccdbusif::evolution::HFP_NETWORK_OPERATOR_NAME),
         (int)::ccdbusif::evolution::IF_NETWORK_OPERATOR))
   {
      onNetworkOperatorNameChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpNetworkOperatorProperty2String(::ccdbusif::evolution::HFP_NETWORK_OPERATOR_STATUS),
         (int)::ccdbusif::evolution::IF_NETWORK_OPERATOR))
   {
      onNetworkStatusChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onPropertyChangedError(
      const ::boost::shared_ptr< NetworkOperatorProxy >& proxy,
      const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onPropertyChangedError"));
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onPropertyChangedSignal(
      const ::boost::shared_ptr< NetworkOperatorProxy >& proxy,
      const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   ETG_TRACE_USR4(("onPropertyChangedSignal(): NetworkOperator"));

   //check received properties for Name and Status
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   ::ccdbusif::evolution::HfpNetworkOperatorProperty propEnum =
         parser.getHfpNetworkOperatorProperty2Enum(signal->getName());

   BTSDbusPropertyList outPropertyList;
   parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getName(),
         (int)::ccdbusif::evolution::IF_NETWORK_OPERATOR);

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("NetworkOperator: ObjPath: %s", objPath.c_str()));

   if(::ccdbusif::evolution::HFP_NETWORK_OPERATOR_NAME == propEnum)
   {
      onNetworkOperatorNameChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_NETWORK_OPERATOR_STATUS == propEnum)
   {
      onNetworkStatusChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onNetworkOperatorNameChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("NetworkOperator: Property: Name"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& name = outProperty.propData.getString();

      ETG_TRACE_USR4(("NetworkOperator: Value: %s", name.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onNetworkOperatorNameChanged(objPath, name);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onNetworkOperatorNameChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onNetworkStatusChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("NetworkOperator: Property: Status"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& status = outProperty.propData.getString();

      ETG_TRACE_USR4(("NetworkOperator: Value: %s", status.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onNetworkStatusChanged(objPath, status);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpNetworkOperatorCallBackIf::onNetworkStatusChanged:Property list size exceeds max limit"));
   }
}

} //evobtstackwrapper
