/**
 * @file EvolutionGeniviDbusHfpModemProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpModem
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpModemProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpModemProperties::EvolutionGeniviDbusHfpModemProperties() : DbusProperties("Modem"),
   // properties
   _propertyPowered("Powered"),
   _propertyName("Name"),
   _propertyInterfaces("Interfaces"),
   _propertyType("Type"),
   _propertyManufacturer("Manufacturer"),
   _propertyModel("Model"),
   _propertyRevision("Revision"),
   _propertySerial("Serial"),

   _interfaceOrgOfonoEvoSiri("org.ofono.evo.Siri"),
   _interfaceOrgOfonoVoiceCallManager("org.ofono.VoiceCallManager"),
   _interfaceOrgOfonoNetworkRegistration("org.ofono.NetworkRegistration"),
   _interfaceOrgOfonoHandsFree("org.ofono.Handsfree"),
   _interfaceOrgOfonoCallVolume("org.ofono.CallVolume"),

   _typeHfp("Hfp"),
   _typeSap("Sap"),
   _typeHardware("Hardware")
{
   _string2EnumList[_propertyPowered] = (int)HFP_MODEM_POWERED;
   _string2EnumList[_propertyName] = (int)HFP_MODEM_NAME;
   _string2EnumList[_propertyInterfaces] = (int)HFP_MODEM_INTERFACES;
   _string2EnumList[_propertyType] = (int)HFP_MODEM_TYPE;
   _string2EnumList[_propertyManufacturer] = (int)HFP_MODEM_MANUFACTURER;
   _string2EnumList[_propertyModel] = (int)HFP_MODEM_MODEL;
   _string2EnumList[_propertyRevision] = (int)HFP_MODEM_REVISION;
   _string2EnumList[_propertySerial] = (int)HFP_MODEM_SERIAL;

   _enum2StringList[(int)HFP_MODEM_POWERED] = &_propertyPowered;
   _enum2StringList[(int)HFP_MODEM_NAME] = &_propertyName;
   _enum2StringList[(int)HFP_MODEM_INTERFACES] = &_propertyInterfaces;
   _enum2StringList[(int)HFP_MODEM_TYPE] = &_propertyType;
   _enum2StringList[(int)HFP_MODEM_MANUFACTURER] = &_propertyManufacturer;
   _enum2StringList[(int)HFP_MODEM_MODEL] = &_propertyModel;
   _enum2StringList[(int)HFP_MODEM_REVISION] = &_propertyRevision;
   _enum2StringList[(int)HFP_MODEM_SERIAL] = &_propertySerial;

   _interface2EnumList[_interfaceOrgOfonoEvoSiri] = (int)HFP_MODEM_INTERFACE_ORG_OFONO_EVO_SIRI;
   _interface2EnumList[_interfaceOrgOfonoVoiceCallManager] = (int)HFP_MODEM_INTERFACE_ORG_OFONO_VOICE_CALL_MANAGER;
   _interface2EnumList[_interfaceOrgOfonoNetworkRegistration] =
         (int)HFP_MODEM_INTERFACE_ORG_OFONO_NETWORK_REGISTRATION;
   _interface2EnumList[_interfaceOrgOfonoHandsFree] = (int)HFP_MODEM_INTERFACE_ORG_OFONO_HANDS_FREE;
   _interface2EnumList[_interfaceOrgOfonoCallVolume] = (int)HFP_MODEM_INTERFACE_ORG_OFONO_CALL_VOLUME;

   _enum2InterfaceList[(int)HFP_MODEM_INTERFACE_ORG_OFONO_EVO_SIRI] = &_interfaceOrgOfonoEvoSiri;
   _enum2InterfaceList[(int)HFP_MODEM_INTERFACE_ORG_OFONO_VOICE_CALL_MANAGER] = &_interfaceOrgOfonoVoiceCallManager;
   _enum2InterfaceList[(int)HFP_MODEM_INTERFACE_ORG_OFONO_NETWORK_REGISTRATION] =
         &_interfaceOrgOfonoNetworkRegistration;
   _enum2InterfaceList[(int)HFP_MODEM_INTERFACE_ORG_OFONO_HANDS_FREE] = &_interfaceOrgOfonoHandsFree;
   _enum2InterfaceList[(int)HFP_MODEM_INTERFACE_ORG_OFONO_CALL_VOLUME] = &_interfaceOrgOfonoCallVolume;

   _type2EnumList[_typeHfp] = (int)HFP_MODEM_TYPE_HFP;
   _type2EnumList[_typeSap] = (int)HFP_MODEM_TYPE_SAP;
   _type2EnumList[_typeHardware] = (int)HFP_MODEM_TYPE_HARDWARE;

   _enum2TypeList[(int)HFP_MODEM_TYPE_HFP] = &_typeHfp;
   _enum2TypeList[(int)HFP_MODEM_TYPE_SAP] = &_typeSap;
   _enum2TypeList[(int)HFP_MODEM_TYPE_HARDWARE] = &_typeHardware;
}

EvolutionGeniviDbusHfpModemProperties::~EvolutionGeniviDbusHfpModemProperties()
{
   _interface2EnumList.clear();
   _enum2InterfaceList.clear();

   _type2EnumList.clear();
   _enum2TypeList.clear();
}

HfpModemProperty EvolutionGeniviDbusHfpModemProperties::getProperty2Enum(const ::std::string& value) const
{
   return (HfpModemProperty)convertString2Enum(value);
}

HfpModemInterfaces EvolutionGeniviDbusHfpModemProperties::getInterface2Enum(const ::std::string& value) const
{
   return (HfpModemInterfaces)convertString2Enum(_interface2EnumList, value);
}

HfpModemTypeSuppValues EvolutionGeniviDbusHfpModemProperties::getType2Enum(const ::std::string& value) const
{
   return (HfpModemTypeSuppValues)convertString2Enum(_type2EnumList, value);
}

const ::std::string& EvolutionGeniviDbusHfpModemProperties::getProperty2String(const HfpModemProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpModemProperties::getProperty2StringTrace(const HfpModemProperty value) const
{
   if(HFP_MODEM_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

const ::std::string& EvolutionGeniviDbusHfpModemProperties::getInterface2StringTrace(
      const HfpModemInterfaces value) const
{
   if(HFP_MODEM_INTERFACE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2InterfaceList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

const ::std::string& EvolutionGeniviDbusHfpModemProperties::getType2StringTrace(
      const HfpModemTypeSuppValues value) const
{
   if(HFP_MODEM_TYPE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2TypeList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
