/**
 * @file EvolutionGeniviDbusHfpManagerRequestIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpManagerRequestIf.h"
#include "IEvolutionGeniviDbusHfpManagerCallBackIf.h"
#include "CcDbusIfTypes.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::Manager;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpManagerRequestIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpManagerRequestIf::EvolutionGeniviDbusHfpManagerRequestIf()
{
   // _hfpManagerProxy is set later
   _callbackIf = nullptr;
}

EvolutionGeniviDbusHfpManagerRequestIf::~EvolutionGeniviDbusHfpManagerRequestIf()
{
   _callbackIf = nullptr;
}

void EvolutionGeniviDbusHfpManagerRequestIf::createProxy(void)
{
   ETG_TRACE_USR3(("createProxy(): Manager"));

   if(nullptr != _callbackIf)
   {
      _hfpManagerProxy = ManagerProxy::createProxy("pmAppEvoHfpManagerPort", *this);
   }
}

void EvolutionGeniviDbusHfpManagerRequestIf::destroyProxy(void)
{
   ETG_TRACE_USR3(("destroyProxy(): Manager"));

   if(nullptr != _hfpManagerProxy.get())
   {
      _hfpManagerProxy->sendDeregisterAll();
      _hfpManagerProxy.reset();
   }
}

void EvolutionGeniviDbusHfpManagerRequestIf::setCallbackIf(IEvolutionGeniviDbusHfpManagerCallBackIf* callbackIf)
{
   _callbackIf = callbackIf;

   // callback interface is now available => create proxy now
   createProxy();
}

void EvolutionGeniviDbusHfpManagerRequestIf::onAvailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onAvailable(): Manager"));

   if((nullptr != _hfpManagerProxy.get()) && (proxy == _hfpManagerProxy))
   {
      if(nullptr != _callbackIf)
      {
         _hfpManagerProxy->sendModemAddedRegister(*_callbackIf);
         _hfpManagerProxy->sendModemRemovedRegister(*_callbackIf);

         _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
               _hfpManagerProxy->getDBusObjectPath());

         //Request modems list
         sendGetModemsRequest();
      }
   }
}

void EvolutionGeniviDbusHfpManagerRequestIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onUnavailable(): Manager"));

   if((nullptr != _hfpManagerProxy.get()) && (proxy == _hfpManagerProxy))
   {
      _hfpManagerProxy->sendDeregisterAll();

      if(nullptr != _callbackIf)
      {
         _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
               _hfpManagerProxy->getDBusObjectPath());
      }
   }
}

act_t EvolutionGeniviDbusHfpManagerRequestIf::sendGetModemsRequest(void)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;

   if((nullptr != _callbackIf) && (nullptr != _hfpManagerProxy.get()))
   {
      act = _hfpManagerProxy->sendGetModemsRequest(*_callbackIf);
   }

   return act;
}

} //evobtstackwrapper
