/**
 * @file EvolutionGeniviDbusHfpHandsfreeRequestIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpHandsfree
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpHandsfreeRequestIf.h"
#include "IEvolutionGeniviDbusHfpHandsfreeCallBackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::Handsfree;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpHandsfreeRequestIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpHandsfreeRequestIf::EvolutionGeniviDbusHfpHandsfreeRequestIf()
{
   // _hfpHandsfreeProxy is set later
   _callbackIf = nullptr;
}

EvolutionGeniviDbusHfpHandsfreeRequestIf::~EvolutionGeniviDbusHfpHandsfreeRequestIf()
{
   _callbackIf = nullptr;
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::destroyProxy(void)
{
   ETG_TRACE_USR3(("destroyProxy(): Handsfree"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpHandsfreeProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("createRuntimeProxy(): Handsfree: ObjPath: %s", objPath.c_str()));

   if(nullptr != _callbackIf)
   {
      if(false == _hfpHandsfreeProxy.isInstanceAvailable(objPath))
      {
         ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
         ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
         ::ccdbusif::convertBusType2ConnectorOption(connectorOptions,
               parser.getInterface2BusType(::ccdbusif::evolution::IF_HANDSFREE));

         ::boost::shared_ptr< HandsfreeProxy > hfpHandsfreeProxy = HandsfreeProxy::createProxy(
               "pmAppEvoHfpHandsfreePort",
               parser.getInterface2BusName(::ccdbusif::evolution::IF_HANDSFREE),
               objPath,
               connectorOptions,
               *this);

         _hfpHandsfreeProxy.addProxyInstance(objPath, hfpHandsfreeProxy);
      }
      else
      {
         ETG_TRACE_ERR(("Handsfree Proxy already existing for requested ObjPath"));
      }
   }
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("destroyRuntimeProxy(): Handsfree: ObjPath: %s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally;
   //       therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration
   //       (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< HandsfreeProxy > hfpHandsfreeProxy;
   if(true == _hfpHandsfreeProxy.isProxyAvailable(hfpHandsfreeProxy, objPath))
   {
      hfpHandsfreeProxy->sendDeregisterAll();
   }
   else
   {
      ETG_TRACE_ERR(("Handsfree Proxy not exist for requested ObjPath"));
   }

   _hfpHandsfreeProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::setCallbackIf(IEvolutionGeniviDbusHfpHandsfreeCallBackIf* callbackIf)
{
   _callbackIf = callbackIf;

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if(nullptr != _callbackIf)
   {
      createRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::deviceRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if(nullptr != _callbackIf)
   {
      destroyRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::onAvailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onAvailable(): Handsfree"));

   for(unsigned int i = 0; i < _hfpHandsfreeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< HandsfreeProxy >& hfpHandsfreeProxy = _hfpHandsfreeProxy[i];
      if((nullptr != hfpHandsfreeProxy.get()) && (proxy == hfpHandsfreeProxy))
      {
         if(nullptr != _callbackIf)
         {
            hfpHandsfreeProxy->sendPropertyChangedRegister(*_callbackIf);
            hfpHandsfreeProxy->sendRecvATCommandRegister(*_callbackIf);
            hfpHandsfreeProxy->sendAgHFindicatorsStateIndRegister(*_callbackIf);
            hfpHandsfreeProxy->sendAgSupportedHFindicatorsIndRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpHandsfreeProxy->getDBusObjectPath());

            //GetProperties
            sendGetPropertiesRequest(hfpHandsfreeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpHandsfreeRequestIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onUnavailable(): Handsfree"));

   for(unsigned int i = 0; i < _hfpHandsfreeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< HandsfreeProxy >& hfpHandsfreeProxy = _hfpHandsfreeProxy[i];
      if((nullptr != hfpHandsfreeProxy.get()) && (proxy == hfpHandsfreeProxy))
      {
         hfpHandsfreeProxy->sendDeregisterAll();

         if(nullptr != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpHandsfreeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

act_t EvolutionGeniviDbusHfpHandsfreeRequestIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< HandsfreeProxy > proxy;

   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpHandsfreeRequestIf::sendSetPropertyRequest(const ::std::string& objPath,
      const ::std::string& property, const bool value)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< HandsfreeProxy > proxy;

   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         ::asf::dbus::DBusVariant variant;
         ::ccdbusif::DbusVariant vValue;
         vValue.setBool(value);
         ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
         parser.addVariantValue(variant, vValue);

         act = proxy->sendSetPropertyRequest(*_callbackIf, property, variant);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpHandsfreeRequestIf::sendSetPropertyRequest(const ::std::string& objPath,
      const ::std::string& property, const ::std::string& value)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< HandsfreeProxy > proxy;

   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         ::asf::dbus::DBusVariant variant;
         ::ccdbusif::DbusVariant vValue;
         vValue.setString(value);
         ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
         parser.addVariantValue(variant, vValue);

         act = proxy->sendSetPropertyRequest(*_callbackIf, property, variant);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpHandsfreeRequestIf::sendRequestPhoneNumberRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< HandsfreeProxy > proxy;

   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendRequestPhoneNumberRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpHandsfreeRequestIf::sendGetSubscriberRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< HandsfreeProxy > proxy;

   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendGetSubscriberRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpHandsfreeRequestIf::sendSendCustomATCommandRequest(const ::std::string& objPath,
      const ::std::vector< uint8 >& data)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< HandsfreeProxy > proxy;

   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendSendCustomATCommandRequest(*_callbackIf, data);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpHandsfreeRequestIf::sendHFUpdateIndicatorsValueRequest(const ::std::string& objPath,
      uint16 number, uint32 value)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< HandsfreeProxy > proxy;

   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendHFUpdateIndicatorsValueRequest(*_callbackIf, number, value);
      }
   }

   return act;
}

} //evobtstackwrapper
