/**
 * @file EvolutionGeniviDbusHfpHandsfreeCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpHandsfree
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpHandsfreeCallBackIf.h"
#include "IBtStackWrapper.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::Handsfree;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpHandsfreeCallBackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpHandsfreeCallBackIf::EvolutionGeniviDbusHfpHandsfreeCallBackIf()
{
   _btStackWrapper = nullptr;
}

EvolutionGeniviDbusHfpHandsfreeCallBackIf::EvolutionGeniviDbusHfpHandsfreeCallBackIf(IBtStackWrapper* btStackWrapper)
{
   _btStackWrapper = btStackWrapper;
}

EvolutionGeniviDbusHfpHandsfreeCallBackIf::~EvolutionGeniviDbusHfpHandsfreeCallBackIf()
{
   _btStackWrapper = nullptr;
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onProxyAvailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onProxyUnavailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onGetPropertiesError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   ETG_TRACE_USR4(("onGetPropertiesError(): Handsfree"));

   (void)(proxy);
   (void)(error);

   //TODO: implement
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onGetPropertiesResponse(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   ETG_TRACE_USR4(("onGetPropertiesResponse(): Handsfree"));

   // check received property for Features, InbandRinging, VoiceRecognition, EchoCancelingNoiseReduction,
   // BatteryChargeLevel, Audio, SCOType, AudioPath, AllCallStatus, ChldFeature and AudioIndicator

   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   BTSDbusPropertyList outPropertyList;

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("Handsfree: ObjPath: %s", objPath.c_str()));

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_FEATURES),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onSupportedFeaturesChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_INBANDRINGING),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onInbandRingingChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_VOICERECOGNITION),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onVoiceRecognitionChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_ECHOCANCELINGNOISEREDUCTION),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onEchoCancelingNoiseReductionChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_BATTERYCHARGELEVEL),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onBatteryChargeLevelChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_AUDIO),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onAudioChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_SCOTYPE),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onSCOTypeChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_AUDIOPATH),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onAudioPathChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_ALLCALLSTATUS),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onAllCallStatusChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_CHLDFEATURE),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onChldFeatureChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_AUDIOINDICATOR),
         (int)::ccdbusif::evolution::IF_HANDSFREE))
   {
      onAudioIndicatorChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSetPropertyError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error)
{
   ETG_TRACE_USR4(("onSetPropertyError(): Handsfree"));

   const std::string& objPath = proxy->getDBusObjectPath();

   const act_t act = error->getAct();
   const std::string& errorMessage = error->getMessage();
   const std::string& errorName = error->getName();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSetPropertyResponse(objPath, ::ccdbusif::evolution::IF_HANDSFREE, errorName,
            errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSetPropertyResponse(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response)
{
   ETG_TRACE_USR4(("onSetPropertyResponse(): Handsfree"));

   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSetPropertyResponse(objPath, ::ccdbusif::evolution::IF_HANDSFREE, "", "", act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onRequestPhoneNumberError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RequestPhoneNumberError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onRequestPhoneNumberError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onRequestPhoneNumberResponse(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< RequestPhoneNumberResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& telephoneNumber = response->getNumber();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onRequestPhoneNumberResponse(objPath, telephoneNumber, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onGetSubscriberError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onGetSubscriberError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onGetSubscriberResponse(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const uint8_t& type = response->getType();
   const std::string& telephoneNumber = response->getNumber();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onGetSubscriberResponse(objPath, type, telephoneNumber, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSendCustomATCommandError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SendCustomATCommandError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSendCustomATCommandError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSendCustomATCommandResponse(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< SendCustomATCommandResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSendCustomATCommandResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onHFUpdateIndicatorsValueError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< HFUpdateIndicatorsValueError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHFUpdateIndicatorsValueError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onHFUpdateIndicatorsValueResponse(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< HFUpdateIndicatorsValueResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHFUpdateIndicatorsValueResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onPropertyChangedError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onPropertyChangedError"));
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onPropertyChangedSignal(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   ETG_TRACE_USR4(("onPropertyChangedSignal(): Handsfree"));

   // check received property for Features, InbandRinging, VoiceRecognition, EchoCancelingNoiseReduction,
   // BatteryChargeLevel, Audio, SCOType, AudioPath, AllCallStatus, ChldFeature and AudioIndicator

   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   ::ccdbusif::evolution::HfpHandsfreeProperty propEnum = parser.getHfpHandsfreeProperty2Enum(signal->getName());

   BTSDbusPropertyList outPropertyList;
   parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getName(),
         (int)::ccdbusif::evolution::IF_HANDSFREE);

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("Handsfree: ObjPath: %s", objPath.c_str()));

   if(::ccdbusif::evolution::HFP_HANDSFREE_FEATURES == propEnum)
   {
      onSupportedFeaturesChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_INBANDRINGING == propEnum)
   {
      onInbandRingingChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_VOICERECOGNITION == propEnum)
   {
      onVoiceRecognitionChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_ECHOCANCELINGNOISEREDUCTION == propEnum)
   {
      onEchoCancelingNoiseReductionChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_BATTERYCHARGELEVEL == propEnum)
   {
      onBatteryChargeLevelChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_AUDIO == propEnum)
   {
      onAudioChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_SCOTYPE == propEnum)
   {
      onSCOTypeChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_AUDIOPATH == propEnum)
   {
      onAudioPathChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_ALLCALLSTATUS == propEnum)
   {
      onAllCallStatusChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_CHLDFEATURE == propEnum)
   {
      onChldFeatureChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_AUDIOINDICATOR == propEnum)
   {
      onAudioIndicatorChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onRecvATCommandError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onRecvATCommandError"));
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onRecvATCommandSignal(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandSignal >& signal)
{
   (void)(proxy);
   (void)(signal);

   //TODO: implement
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAgHFindicatorsStateIndError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< AgHFindicatorsStateIndError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAgHFindicatorsStateIndError"));
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAgHFindicatorsStateIndSignal(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< AgHFindicatorsStateIndSignal >& signal)
{
   (void)(proxy);
   (void)(signal);

   //TODO: implement
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAgSupportedHFindicatorsIndError(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< AgSupportedHFindicatorsIndError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAgSupportedHFindicatorsIndError"));
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAgSupportedHFindicatorsIndSignal(
      const ::boost::shared_ptr< HandsfreeProxy >& proxy,
      const ::boost::shared_ptr< AgSupportedHFindicatorsIndSignal >& signal)
{
   (void)(proxy);
   (void)(signal);

   //TODO: implement
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSupportedFeaturesChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: Features"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const ::std::vector<std::string>& featureList = outProperty.propData.getStringArray();

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onSupportedFeaturesChanged(objPath, featureList);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSupportedFeaturesChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onInbandRingingChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: InbandRinging"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const bool inbandRinging = outProperty.propData.getBool();

      ETG_TRACE_USR4(("Handsfree: Value: %d", inbandRinging));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onInbandRingingChanged(objPath, inbandRinging);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onInbandRingingChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onVoiceRecognitionChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: VoiceRecognition"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const bool voiceRecognition = outProperty.propData.getBool();

      ETG_TRACE_USR4(("Handsfree: Value: %d", voiceRecognition));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onVoiceRecognitionChanged(objPath, voiceRecognition);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onVoiceRecognitionChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onEchoCancelingNoiseReductionChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: EchoCancellingNoiseReduction"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const bool ecnr = outProperty.propData.getBool();

      ETG_TRACE_USR4(("Handsfree: Value: %d", ecnr));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onEchoCancelingNoiseReductionChanged(objPath, ecnr);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onEchoCancelingNoiseReductionChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onBatteryChargeLevelChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: BatteryChargeLevel"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const uint8_t& batteryChargeLevel = outProperty.propData.getUInt8();

      ETG_TRACE_USR4(("Handsfree: Value: %d", batteryChargeLevel));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onBatteryChargeLevelChanged(objPath, batteryChargeLevel);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onBatteryChargeLevelChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAudioChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: Audio"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::string& audio = outProperty.propData.getString();

      ETG_TRACE_USR4(("Handsfree: Value: %s", audio.c_str()));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onAudioChanged(objPath, audio);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAudioChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSCOTypeChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: SCOType"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const uint8_t& scoType = outProperty.propData.getUInt8();

      ETG_TRACE_USR4(("Handsfree: Value: %d", scoType));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onSCOTypeChanged(objPath, scoType);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onSCOTypeChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAudioPathChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: AudioPath"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const uint8_t& audioPath = outProperty.propData.getUInt8();

      ETG_TRACE_USR4(("Handsfree: Value: %d", audioPath));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onAudioPathChanged(objPath, audioPath);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAudioPathChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAllCallStatusChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: AllCallStatus"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const uint8_t& allCallStatus = outProperty.propData.getUInt8();

      ETG_TRACE_USR4(("Handsfree: Value: %d", allCallStatus));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onAllCallStatusChanged(objPath, allCallStatus);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAllCallStatusChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onChldFeatureChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: ChldFeature"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const ::std::vector<std::string>& childFeatureList = outProperty.propData.getStringArray();

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onChldFeatureChanged(objPath, childFeatureList);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onChldFeatureChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAudioIndicatorChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Handsfree: Property: AudioIndicator"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const uint8_t& audioIndicator = outProperty.propData.getUInt8();

      ETG_TRACE_USR4(("Handsfree: Value: %d", audioIndicator));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onAudioIndicatorChanged(objPath, audioIndicator);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpHandsfreeCallBackIf::onAudioIndicatorChanged:Property list size exceeds max limit"));
   }
}

} //evobtstackwrapper
