/**
 * @file EvolutionGeniviDbusHfpCallVolumeRequestIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpCallVolume
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpCallVolumeRequestIf.h"
#include "IEvolutionGeniviDbusHfpCallVolumeCallBackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::CallVolume;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpCallVolumeRequestIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpCallVolumeRequestIf::EvolutionGeniviDbusHfpCallVolumeRequestIf()
{
   // _hfpCallVolumeProxy is set later
   _callbackIf = nullptr;
}

EvolutionGeniviDbusHfpCallVolumeRequestIf::~EvolutionGeniviDbusHfpCallVolumeRequestIf()
{
   _callbackIf = nullptr;
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::destroyProxy(void)
{
   ETG_TRACE_USR3(("destroyProxy(): CallVolume"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpCallVolumeProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("createRuntimeProxy(): CallVolume: ObjPath: %s", objPath.c_str()));

   if(nullptr != _callbackIf)
   {
      if(false == _hfpCallVolumeProxy.isInstanceAvailable(objPath))
      {
         ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
         ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
         ::ccdbusif::convertBusType2ConnectorOption(connectorOptions,
               parser.getInterface2BusType(::ccdbusif::evolution::IF_CALL_VOLUME));

         ::boost::shared_ptr< CallVolumeProxy > hfpCallVolumeProxy = CallVolumeProxy::createProxy(
               "pmAppEvoHfpCallVolumePort",
               parser.getInterface2BusName(::ccdbusif::evolution::IF_CALL_VOLUME),
               objPath,
               connectorOptions,
               *this);

         _hfpCallVolumeProxy.addProxyInstance(objPath, hfpCallVolumeProxy);
      }
      else
      {
         ETG_TRACE_ERR(("CallVolume Proxy already existing for requested ObjPath"));
      }
   }
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("destroyRuntimeProxy(): CallVolume: ObjPath: %s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally;
   //       therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration
   //       (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< CallVolumeProxy > hfpCallVolumeProxy;
   if(true == _hfpCallVolumeProxy.isProxyAvailable(hfpCallVolumeProxy, objPath))
   {
      hfpCallVolumeProxy->sendDeregisterAll();
   }
   else
   {
      ETG_TRACE_ERR(("CallVolume Proxy not exist for requested ObjPath"));
   }

   _hfpCallVolumeProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::setCallbackIf(IEvolutionGeniviDbusHfpCallVolumeCallBackIf* callbackIf)
{
   _callbackIf = callbackIf;

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if(nullptr != _callbackIf)
   {
      createRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::deviceRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if(nullptr != _callbackIf)
   {
      destroyRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::onAvailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onAvailable(): CallVolume"));

   for(unsigned int i = 0; i < _hfpCallVolumeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< CallVolumeProxy >& hfpCallVolumeProxy = _hfpCallVolumeProxy[i];
      if((nullptr != hfpCallVolumeProxy.get()) && (proxy == hfpCallVolumeProxy))
      {
         if(nullptr != _callbackIf)
         {
            hfpCallVolumeProxy->sendPropertyChangedRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpCallVolumeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpCallVolumeRequestIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onUnavailable(): CallVolume"));

   for(unsigned int i = 0; i < _hfpCallVolumeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< CallVolumeProxy >& hfpCallVolumeProxy = _hfpCallVolumeProxy[i];
      if((nullptr != hfpCallVolumeProxy.get()) && (proxy == hfpCallVolumeProxy))
      {
         hfpCallVolumeProxy->sendDeregisterAll();

         if(nullptr != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpCallVolumeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

act_t EvolutionGeniviDbusHfpCallVolumeRequestIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< CallVolumeProxy > proxy;

   if(true == _hfpCallVolumeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }

   return act;
}

act_t EvolutionGeniviDbusHfpCallVolumeRequestIf::sendSetPropertyRequest(const ::std::string& objPath,
      const ::std::string& property, const uint8 value)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< CallVolumeProxy > proxy;

   if(true == _hfpCallVolumeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         ::asf::dbus::DBusVariant variant;
         ::ccdbusif::DbusVariant vValue;
         vValue.setUInt8(value);
         ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
         parser.addVariantValue(variant, vValue);

         act = proxy->sendSetPropertyRequest(*_callbackIf, property, variant);
      }
   }

   return act;
}

} //evobtstackwrapper
