/**
 * @file EvolutionGeniviDbusHfpCallVolumeCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpCallVolume
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpCallVolumeCallBackIf.h"
#include "IBtStackWrapper.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::CallVolume;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpCallVolumeCallBackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpCallVolumeCallBackIf::EvolutionGeniviDbusHfpCallVolumeCallBackIf()
{
   _btStackWrapper = nullptr;
}

EvolutionGeniviDbusHfpCallVolumeCallBackIf::EvolutionGeniviDbusHfpCallVolumeCallBackIf(IBtStackWrapper* btStackWrapper)
{
   _btStackWrapper = btStackWrapper;
}

EvolutionGeniviDbusHfpCallVolumeCallBackIf::~EvolutionGeniviDbusHfpCallVolumeCallBackIf()
{
   _btStackWrapper = nullptr;
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onProxyAvailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onProxyUnavailable(
      const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onGetPropertiesError(
      const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   ETG_TRACE_USR4(("onGetPropertiesError(): CallVolume"));

   (void)(proxy);
   (void)(error);

   //TODO: implement
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onGetPropertiesResponse(
      const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   ETG_TRACE_USR4(("onGetPropertiesResponse(): CallVolume"));

   //check received properties for SpeakerVolume and MicrophoneVolume
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   BTSDbusPropertyList outPropertyList;

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("CallVolume: ObjPath: %s", objPath.c_str()));

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpCallVolumeProperty2String(::ccdbusif::evolution::HFP_CALL_VOLUME_SPEAKERVOLUME),
         (int)::ccdbusif::evolution::IF_CALL_VOLUME))
   {
      onSpeakerVolumeChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpCallVolumeProperty2String(::ccdbusif::evolution::HFP_CALL_VOLUME_MICROPHONEVOLUME),
         (int)::ccdbusif::evolution::IF_CALL_VOLUME))
   {
      onMicrophoneVolumeChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onSetPropertyError(
      const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error)
{
   ETG_TRACE_USR4(("onSetPropertyError(): CallVolume"));

   (void)(proxy);
   (void)(error);

   //TODO: implement
   //const std::string& objPath = proxy->getDBusObjectPath();
   //const std::string& errorName = error->getName();
   //const std::string& errorMessage = error->getMessage();
   //const act_t act = error->getAct();
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onSetPropertyResponse(
      const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response)
{
   ETG_TRACE_USR4(("onSetPropertyResponse(): CallVolume"));

   (void)(proxy);
   (void)(response);

   //TODO: implement
   //const std::string& objPath = proxy->getDBusObjectPath();
   //const act_t act = response->getAct();
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onPropertyChangedError(
      const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpCallVolumeCallBackIf::onPropertyChangedError"));
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onPropertyChangedSignal(
      const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   ETG_TRACE_USR4(("onPropertyChangedSignal(): CallVolume"));

   //check received properties for SpeakerVolume and MicrophoneVolume
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   ::ccdbusif::evolution::HfpCallVolumeProperty propEnum = parser.getHfpCallVolumeProperty2Enum(signal->getProperty());

   BTSDbusPropertyList outPropertyList;
   parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getProperty(),
         (int)::ccdbusif::evolution::IF_CALL_VOLUME);

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("CallVolume: ObjPath: %s", objPath.c_str()));

   if(::ccdbusif::evolution::HFP_CALL_VOLUME_SPEAKERVOLUME == propEnum)
   {
      onSpeakerVolumeChanged(objPath, outPropertyList);
   }
   else if(::ccdbusif::evolution::HFP_CALL_VOLUME_MICROPHONEVOLUME == propEnum)
   {
      onMicrophoneVolumeChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onSpeakerVolumeChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("CallVolume: Property: SpeakerVolume"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const uint8_t& speakerVolume = outProperty.propData.getUInt8();

      ETG_TRACE_USR4(("CallVolume: Value: %d", speakerVolume));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onSpeakerVolumeChanged(objPath, speakerVolume);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpCallVolumeCallBackIf::onSpeakerVolumeChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpCallVolumeCallBackIf::onMicrophoneVolumeChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("CallVolume: Property: MicrophoneVolume"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const uint8_t& microphoneVolume = outProperty.propData.getUInt8();

      ETG_TRACE_USR4(("CallVolume: Value: %d", microphoneVolume));

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onMicrophoneVolumeChanged(objPath, microphoneVolume);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpCallVolumeCallBackIf::onMicrophoneVolumeChanged:Property list size exceeds max limit"));
   }
}

} //evobtstackwrapper
