/**
 * @file IEvolutionGeniviDbusHfpVoiceCallRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS send request for HfpVoiceCall
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpVoiceCallRequestIf_h
#define IEvolutionGeniviDbusHfpVoiceCallRequestIf_h

#include <stdbool.h>
#include <string>

#include "asf/core/Types.h"

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpVoiceCallCallBackIf;

/**
 * Send request interface class for HfpVoiceCall.
 */
class IEvolutionGeniviDbusHfpVoiceCallRequestIf
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpVoiceCallRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpVoiceCallCallBackIf* callbackIf) = 0;

   /**
    * Handle signal for created voice call.
    *
    * @param[in] objPath: object path of created call
    * @param[out]
    * @param[in,out]
    *
    * @return bool - true- Created voice call proxy, false- proxy is already present.
    */
   virtual bool voiceCallCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed voice call.
    *
    * @param[in] objPath: object path of removed call
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void voiceCallRemoved(const ::std::string& objPath) = 0;

   /**
    * Send GetProperties Request.
    *
    * @param[in] objPath: object path of call
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) = 0;

   /**
    * Send Hangup Request.
    *
    * @param[in] objPath: object path of call
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendHangupRequest(const ::std::string& objPath) = 0;

   /**
    * Send Answer Request.
    *
    * @param[in] objPath: object path of call
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendAnswerRequest(const ::std::string& objPath) = 0;

   /**
    * Send Hold Request.
    *
    * @param[in] objPath: object path of call
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendHoldRequest(const ::std::string& objPath) = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpVoiceCallRequestIf_h
