/**
 * @file IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpVoiceCallManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf_h
#define IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf_h

#include "org/ofono/VoiceCallManagerProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HfpVoiceCallManager.
 */
class IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf :
   public ::org::ofono::VoiceCallManager::GetPropertiesCallbackIF,
   public ::org::ofono::VoiceCallManager::GetCallsCallbackIF,
   public ::org::ofono::VoiceCallManager::DialCallbackIF,
   public ::org::ofono::VoiceCallManager::MemDialCallbackIF,
   public ::org::ofono::VoiceCallManager::RedialCallbackIF,
   public ::org::ofono::VoiceCallManager::SwapCallsCallbackIF,
   public ::org::ofono::VoiceCallManager::ReleaseAndAnswerCallbackIF,
   public ::org::ofono::VoiceCallManager::ReleaseAndSwapCallbackIF,
   public ::org::ofono::VoiceCallManager::HoldAndAnswerCallbackIF,
   public ::org::ofono::VoiceCallManager::HangupAllCallbackIF,
   public ::org::ofono::VoiceCallManager::PrivateChatCallbackIF,
   public ::org::ofono::VoiceCallManager::CreateMultipartyCallbackIF,
   public ::org::ofono::VoiceCallManager::HangupMultipartyCallbackIF,
   public ::org::ofono::VoiceCallManager::SendTonesCallbackIF,
   public ::org::ofono::VoiceCallManager::CallAddedCallbackIF,
   public ::org::ofono::VoiceCallManager::CallRemovedCallbackIF,
   public ::org::ofono::VoiceCallManager::PropertyChangedCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetProperties request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to GetpropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetPropertiesError >& error) override = 0;

   /**
    * Callback method for GetProperties request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to GetPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetPropertiesResponse >& response) override = 0;

   /**
    * Error callback method for GetCalls request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to GetCallsError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetCallsError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetCallsError >& error) override = 0;

   /**
    * Callback method for GetCalls request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to GetCallsResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetCallsResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetCallsResponse >& response) override = 0;

   /**
    * Error callback method for Dial request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to DialError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onDialError(const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::DialError >& error) override = 0;

   /**
    * Callback method for Dial request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to DialResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onDialResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::DialResponse >& response) override = 0;

   /**
    * Error callback method for MemDial request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to MemDialError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onMemDialError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::MemDialError >& error) override = 0;

   /**
    * Callback method for MemDial request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to MemDialResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onMemDialResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::MemDialResponse >& response) override = 0;

   /**
    * Error callback method for Redial request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to RedialError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRedialError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::RedialError >& error) override = 0;

   /**
    * Callback method for Redial request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to RedialResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRedialResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::RedialResponse >& response) override = 0;

   /**
    * Error callback method for SwapCalls request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to SwapCallsError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSwapCallsError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SwapCallsError >& error) override = 0;

   /**
    * Callback method for SwapCalls request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to SwapCallsResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSwapCallsResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SwapCallsResponse >& response) override = 0;

   /**
    * Error callback method for ReleaseAndAnswer request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to ReleaseAndAnswerError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndAnswerError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndAnswerError >& error) override = 0;

   /**
    * Callback method for ReleaseAndAnswer request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to ReleaseAndAnswerResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndAnswerResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndAnswerResponse >& response) override = 0;

   /**
    * Error callback method for ReleaseAndSwap request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to ReleaseAndSwapError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndSwapError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndSwapError >& error) override = 0;

   /**
    * Callback method for ReleaseAndSwap request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to ReleaseAndSwapResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndSwapResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndSwapResponse >& response) override = 0;

   /**
    * Error callback method for HoldAndAnswer request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to HoldAndAnswerError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldAndAnswerError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HoldAndAnswerError >& error) override = 0;

   /**
    * Callback method for HoldAndAnswer request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to HoldAndAnswerResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldAndAnswerResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HoldAndAnswerResponse >& response) override = 0;

   /**
    * Error callback method for HangupAll request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to HangupAllError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupAllError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupAllError >& error) override = 0;

   /**
    * Callback method for HangupAll request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to HangupAllResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupAllResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupAllResponse >& response) override = 0;

   /**
    * Error callback method for PrivateChat request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to PrivateChatError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPrivateChatError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PrivateChatError >& error) override = 0;

   /**
    * Callback method for PrivateChat request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to PrivateChatResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPrivateChatResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PrivateChatResponse >& response) override = 0;

   /**
    * Error callback method for CreateMultiparty request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to CreateMultipartyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCreateMultipartyError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CreateMultipartyError >& error) override = 0;

   /**
    * Callback method for CreateMultiparty request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to CreateMultipartyResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCreateMultipartyResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CreateMultipartyResponse >& response) override = 0;

   /**
    * Error callback method for HangupMultiparty request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to HangupMultipartyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupMultipartyError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupMultipartyError >& error) override = 0;

   /**
    * Callback method for HangupMultiparty request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to HangupMultipartyResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupMultipartyResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupMultipartyResponse >& response) override = 0;

   /**
    * Error callback method for SendTones request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to SendTonesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendTonesError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SendTonesError >& error) override = 0;

   /**
    * Callback method for SendTones request
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] response - reference to SendTonesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendTonesResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SendTonesResponse >& response) override = 0;

   /**
    * Error callback method for CallAdded signal
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to CallAddedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallAddedError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallAddedError >& error) override = 0;

   /**
    * Callback method for CallAdded signal
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] signal - reference to CallAddedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallAddedSignal(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallAddedSignal >& signal) override = 0;

   /**
    * Error callback method for CallRemoved signal
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to CallRemovedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallRemovedError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallRemovedError >& error) override = 0;

   /**
    * Callback method for CallRemoved signal
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] signal - reference to CallRemovedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallRemovedSignal(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallRemovedSignal >& signal) override = 0;

   /**
    * Error callback for PropertyChanged signal
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] error - reference to PropertyChangedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PropertyChangedError >& error) override = 0;

   /**
    * Callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of VoiceCallManager proxy
    * @param[in] signal - reference to PropertyChangedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PropertyChangedSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf_h
