/**
 * @file IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS send request for HfpNetworkRegistration
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf_h
#define IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf_h

#include <stdbool.h>
#include <string>

#include "asf/core/Types.h"

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf;

/**
 * Send request interface class for HfpNetworkRegistration.
 */
class IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf* callbackIf) = 0;

   /**
    * Handle signal for created device.
    *
    * @param[in] objPath: object path of created device
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void deviceCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed device.
    *
    * @param[in] objPath: object path of removed device
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void deviceRemoved(const ::std::string& objPath) = 0;

   /**
    * Send GetProperties Request.
    *
    * @param[in] objPath: object path of device
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) = 0;
};

} //evobtstackwrapper

#endif // IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf_h
