/**
 * @file IEvolutionGeniviDbusHfpNetworkOperatorRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS send request for HfpNetworkOperator
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpNetworkOperatorRequestIf_h
#define IEvolutionGeniviDbusHfpNetworkOperatorRequestIf_h

#include <stdbool.h>
#include <string>

#include "asf/core/Types.h"

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf;

/**
 * Send request interface class for HfpNetworkOperator.
 */
class IEvolutionGeniviDbusHfpNetworkOperatorRequestIf
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpNetworkOperatorRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf* callbackIf) = 0;

   /**
    * Handle signal for created network operator.
    *
    * @param[in] objPath: object path of created operator
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void networkOperatorCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed operator.
    *
    * @param[in] objPath: object path of removed network operator
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void networkOperatorRemoved(const ::std::string& objPath) = 0;

   /**
    * Send GetProperties Request.
    *
    * @param[in] objPath: object path of operator
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpNetworkOperatorRequestIf_h
