/**
 * @file IEvolutionGeniviDbusHfpModemRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS send request for HfpModem
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpModemRequestIf_h
#define IEvolutionGeniviDbusHfpModemRequestIf_h

#include <stdbool.h>
#include <string>

#include "asf/core/Types.h"

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpModemCallBackIf;

/**
 * Send request interface class for HfpModem.
 */
class IEvolutionGeniviDbusHfpModemRequestIf
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpModemRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpModemCallBackIf* callbackIf) = 0;

   /**
    * Handle signal for created modem.
    *
    * @param[in] objPath: object path of created modem
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void modemCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed modem.
    *
    * @param[in] objPath: object path of removed modem
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void modemRemoved(const ::std::string& objPath) = 0;

   /**
    * Send GetProperties Request.
    *
    * @param[in] objPath: object path of modem
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) = 0;

   /**
    * Send SetProperty Request.
    *
    * @param[in] objPath: object path of modem
    * @param[in] property: property string to be updated
    * @param[in] value: property value to be updated
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property,
         const bool value) = 0;

   /**
    * Send AcceptSCOConnect Request.
    *
    * @param[in] objPath: object path of modem
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendAcceptSCOConnectRequest(const ::std::string& objPath) = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpModemRequestIf_h
