/**
 * @file IEvolutionGeniviDbusHfpModemCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpModem
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpModemCallBackIf_h
#define IEvolutionGeniviDbusHfpModemCallBackIf_h

#include "org/ofono/ModemProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HfpModem.
 */
class IEvolutionGeniviDbusHfpModemCallBackIf :
   public ::org::ofono::Modem::GetPropertiesCallbackIF,
   public ::org::ofono::Modem::SetPropertyCallbackIF,
   public ::org::ofono::Modem::AcceptSCOConnectCallbackIF,
   public ::org::ofono::Modem::PropertyChangedCallbackIF,
   public ::org::ofono::Modem::SCOConnectRequestCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpModemCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetProperties request
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] error - reference to GetPropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::GetPropertiesError >& error) override = 0;

   /**
    * Callback method for GetProperties request
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] response - reference to GetPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::GetPropertiesResponse >& response) override = 0;

   /**
    * Error callback method for SetProperty request
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] error - reference to SetPropertyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SetPropertyError >& error) override = 0;

   /**
    * Callback method for SetProperty request
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] response - reference to SetPropertyResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SetPropertyResponse >& response) override = 0;

   /**
    * Error callback method for AcceptSCOConnect request
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] error - reference to AcceptSCOConnectError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAcceptSCOConnectError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::AcceptSCOConnectError >& error) override = 0;

   /**
    * Callback method for AcceptSCOConnect request
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] response - reference to AcceptSCOConnectResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAcceptSCOConnectResponse(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::AcceptSCOConnectResponse >& response) override = 0;

   /**
    * Error callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] error - reference to PropertyChangedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::PropertyChangedError >& error) override = 0;

   /**
    * Callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] signal - reference to PropertyChangedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::PropertyChangedSignal >& signal) override = 0;

   /**
    * Error callback method for SCOConnectRequest signal
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] error - reference to SCOConnectRequestError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSCOConnectRequestError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SCOConnectRequestError >& error) override = 0;

   /**
    * Callback method for SCOConnectRequest signal
    *
    * @param[in] proxy - reference of Modem proxy
    * @param[in] signal - reference to SCOConnectRequestSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSCOConnectRequestSignal(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SCOConnectRequestSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpModemCallBackIf_h
