/**
 * @file IEvolutionGeniviDbusHfpManagerRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS send request for HfpManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpManagerRequestIf_h
#define IEvolutionGeniviDbusHfpManagerRequestIf_h

#include <stdbool.h>

#include "asf/core/Types.h"

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpManagerCallBackIf;

/**
 * Send request interface class for HfpManager.
 */
class IEvolutionGeniviDbusHfpManagerRequestIf
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpManagerRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpManagerRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpManagerCallBackIf* callbackIf) = 0;

   /**
    * Send GetModems Request.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetModemsRequest(void) = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpManagerRequestIf_h
