/**
 * @file IEvolutionGeniviDbusHfpManagerCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpManagerCallBackIf_h
#define IEvolutionGeniviDbusHfpManagerCallBackIf_h

#include "org/ofono/ManagerProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HfpManager.
 */
class IEvolutionGeniviDbusHfpManagerCallBackIf :
   public ::org::ofono::Manager::GetModemsCallbackIF,
   public ::org::ofono::Manager::ModemAddedCallbackIF,
   public ::org::ofono::Manager::ModemRemovedCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpManagerCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetModems request
    *
    * @param[in] proxy - reference of Manager proxy
    * @param[in] error - reference to GetModemsError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetModemsError(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::GetModemsError >& error) override = 0;

   /**
    * Callback method for GetModems request
    *
    * @param[in] proxy - reference of Manager proxy
    * @param[in] response - reference to GetModemsResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetModemsResponse(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::GetModemsResponse >& response) override = 0;

   /**
    * Error callback method for ModemAdded request
    *
    * @param[in] proxy - reference of Manager proxy
    * @param[in] error - reference to ModemAddedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemAddedError(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemAddedError >& error) override = 0;

   /**
    * Callback method for ModemAdded signal
    *
    * @param[in] proxy - reference of Manager proxy
    * @param[in] signal - reference to ModemAddedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemAddedSignal(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemAddedSignal >& signal) override = 0;

   /**
    * Error callback method for ModemRemoved signal
    *
    * @param[in] proxy - reference of Manager proxy
    * @param[in] error - reference to ModemRemovedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemRemovedError(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemRemovedError >& error) override = 0;

   /**
    * Callback method for ModemRemoved signal
    *
    * @param[in] proxy - reference of Manager proxy
    * @param[in] signal - reference to ModemRemovedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemRemovedSignal(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemRemovedSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpManagerCallBackIf_h
