/**
 * @file IEvolutionGeniviDbusHfpHandsfreeCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpHandsfree
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpHandsfreeCallBackIf_h
#define IEvolutionGeniviDbusHfpHandsfreeCallBackIf_h

#include "org/ofono/HandsfreeProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HfpHandsfree.
 */
class IEvolutionGeniviDbusHfpHandsfreeCallBackIf :
   public ::org::ofono::Handsfree::GetPropertiesCallbackIF,
   public ::org::ofono::Handsfree::SetPropertyCallbackIF,
   public ::org::ofono::Handsfree::RequestPhoneNumberCallbackIF,
   public ::org::ofono::Handsfree::GetSubscriberCallbackIF,
   public ::org::ofono::Handsfree::SendCustomATCommandCallbackIF,
   public ::org::ofono::Handsfree::HFUpdateIndicatorsValueCallbackIF,
   public ::org::ofono::Handsfree::PropertyChangedCallbackIF,
   public ::org::ofono::Handsfree::RecvATCommandCallbackIF,
   public ::org::ofono::Handsfree::AgSupportedHFindicatorsIndCallbackIF,
   public ::org::ofono::Handsfree::AgHFindicatorsStateIndCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpHandsfreeCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetProperties request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to GetPropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetPropertiesError >& error) override = 0;

   /**
    * Callback method for GetProperties request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] response - reference to GetPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetPropertiesResponse >& response) override = 0;

   /**
    * Error callback method for SetProperty request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to SetPropertyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SetPropertyError >& error) override = 0;

   /**
    * Callback method for SetProperty request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] response - reference to SetPropertyResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SetPropertyResponse >& response) override = 0;

   /**
    * Error callback method for RequestPhoneNumber request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to RequestPhoneNumberError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRequestPhoneNumberError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RequestPhoneNumberError >& error) override = 0;

   /**
    * Callback method for RequestPhoneNumber request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] response - reference to RequestPhoneNumberResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRequestPhoneNumberResponse(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RequestPhoneNumberResponse >& response) override = 0;

   /**
    * Error callback method for GetSubscriber request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to GetSubscriberError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetSubscriberError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetSubscriberError >& error) override = 0;

   /**
    * Callback method for GetSubscriber request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] response - reference to GetSubscriberResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetSubscriberResponse(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetSubscriberResponse >& response) override = 0;

   /**
    * Error callback method for SendCustomATCommand request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to SendCustomATCommandError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendCustomATCommandError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SendCustomATCommandError >& error) override = 0;

   /**
    * Callback method for SendCustomATCommand request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] response - reference to SendCustomATCommandResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendCustomATCommandResponse(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SendCustomATCommandResponse >& response) override = 0;

   /**
    * Error callback method for HFUpdateIndicatorsValue request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to HFUpdateIndicatorsValueError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHFUpdateIndicatorsValueError(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HFUpdateIndicatorsValueError >& error) override = 0;

   /**
    * Callback method for HFUpdateIndicatorsValue request
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] response - reference to HFUpdateIndicatorsValueResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHFUpdateIndicatorsValueResponse(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HFUpdateIndicatorsValueResponse >& response) override = 0;

   /**
    * Error callback for PropertyChanged signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to PropertyChangedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::PropertyChangedError >& error) override = 0;

   /**
    * Callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] signal - reference to PropertyChangedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::PropertyChangedSignal >& signal) override = 0;

   /**
    * Error callback for RecvATCommand signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to RecvATCommandError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRecvATCommandError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RecvATCommandError >& error) override = 0;

   /**
    * Callback method for RecvATCommand signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] signal - reference to RecvATCommandSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRecvATCommandSignal(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RecvATCommandSignal >& signal) override = 0;

   /**
    * Error callback for AgHFindicatorsStateInd signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to AgHFindicatorsStateIndError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgHFindicatorsStateIndError(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgHFindicatorsStateIndError >& error) override = 0;

   /**
    * Callback method for AgHFindicatorsStateInd signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] signal - reference to AgHFindicatorsStateIndSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgHFindicatorsStateIndSignal(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgHFindicatorsStateIndSignal >& signal) override = 0;

   /**
    * Error callback for AgSupportedHFindicatorsInd signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] error - reference to AgSupportedHFindicatorsIndError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgSupportedHFindicatorsIndError(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgSupportedHFindicatorsIndError >& error) override = 0;

   /**
    * Callback method for AgSupportedHFindicatorsInd signal
    *
    * @param[in] proxy - reference of Handsfree proxy
    * @param[in] signal - reference to AgSupportedHFindicatorsIndSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgSupportedHFindicatorsIndSignal(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgSupportedHFindicatorsIndSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif // IEvolutionGeniviDbusHfpHandsfreeCallBackIf_h
