/**
 * @file IEvolutionGeniviDbusHfpCallVolumeCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpCallVolume
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpCallVolumeCallBackIf_h
#define IEvolutionGeniviDbusHfpCallVolumeCallBackIf_h

#include "org/ofono/CallVolumeProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HfpCallVolume.
 */
class IEvolutionGeniviDbusHfpCallVolumeCallBackIf :
   public ::org::ofono::CallVolume::GetPropertiesCallbackIF,
   public ::org::ofono::CallVolume::SetPropertyCallbackIF,
   public ::org::ofono::CallVolume::PropertyChangedCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpCallVolumeCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetProperties request
    *
    * @param[in] proxy - reference of CallVolume proxy
    * @param[in] error - reference to GetPropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::GetPropertiesError >& error) override = 0;

   /**
    * Callback method for GetProperties request
    *
    * @param[in] proxy - reference of CallVolume proxy
    * @param[in] response - reference to GetPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::GetPropertiesResponse >& response) override = 0;

   /**
    * Error callback method for SetProperty request
    *
    * @param[in] proxy - reference of CallVolume proxy
    * @param[in] error - reference to SetPropertyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::SetPropertyError >& error) override = 0;

   /**
    * Callback method for SetProperty resquest
    *
    * @param[in] proxy - reference of CallVolume proxy
    * @param[in] response - reference to SetPropertyResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::SetPropertyResponse >& response) override = 0;

   /**
    * Error callback for PropertyChanged signal
    *
    * @param[in] proxy - reference of CallVolume proxy
    * @param[in] error - reference to PropertyChangedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::PropertyChangedError >& error) override = 0;

   /**
    * Callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of CallVolume proxy
    * @param[in] signal - reference to PropertyChangedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::PropertyChangedSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif // IEvolutionGeniviDbusHfpCallVolumeCallBackIf_h
