/**
 * @file EvolutionGeniviDbusHfpVoiceCallProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpVoiceCall
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpVoiceCallProperties_h
#define EvolutionGeniviDbusHfpVoiceCallProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpVoiceCall properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpVoiceCallProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpVoiceCallProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpVoiceCallProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpVoiceCallProperties();

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpVoiceCallProperty - property enum value
    */
   HfpVoiceCallProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpVoiceCallProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpVoiceCallProperty value) const;

private:
   const ::std::string _propertyLineIdentification; /**< property LineIdentification */
   const ::std::string _propertyName;               /**< property Name */
   const ::std::string _propertyMultiparty;         /**< property Multiparty */
   const ::std::string _propertyState;              /**< property State */
   const ::std::string _propertyEmergency;          /**< property Emergency */
   const ::std::string _propertyDirection;          /**< property Direction */
   const ::std::string _propertyMode;               /**< property Mode */
   const ::std::string _propertyType;               /**< property Type */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpVoiceCallProperties_h
