/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpVoiceCallManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpVoiceCallManagerProperties_h
#define EvolutionGeniviDbusHfpVoiceCallManagerProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpVoiceCallManager properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallManagerProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpVoiceCallManagerProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpVoiceCallManagerProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpVoiceCallManagerProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpVoiceCallManagerProperties();

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpVoiceCallManagerProperty - property enum value
    */
   HfpVoiceCallManagerProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpVoiceCallManagerProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpVoiceCallManagerProperty value) const;

private:
   const ::std::string _propertyEmergencyNumbers; /**< property EmergencyNumbers */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpVoiceCallManagerProperties_h
