/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpVoiceCallManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf_h
#define EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf_h

#include "IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"
#include "CcDbusIfTypes.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

//class forward declarations
class IBtStackWrapper;

/**
 * HfpVoiceCallManager callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf : public IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetCallsError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetCallsError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetCallsResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::GetCallsResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onDialError(const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::DialError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onDialResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::DialResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onMemDialError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::MemDialError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onMemDialResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::MemDialResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRedialError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::RedialError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRedialResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::RedialResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSwapCallsError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SwapCallsError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSwapCallsResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SwapCallsResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndAnswerError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndAnswerError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndAnswerResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndAnswerResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndSwapError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndSwapError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onReleaseAndSwapResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::ReleaseAndSwapResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldAndAnswerError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HoldAndAnswerError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldAndAnswerResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HoldAndAnswerResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupAllError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupAllError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupAllResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupAllResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPrivateChatError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PrivateChatError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPrivateChatResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PrivateChatResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCreateMultipartyError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CreateMultipartyError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCreateMultipartyResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CreateMultipartyResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupMultipartyError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupMultipartyError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupMultipartyResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::HangupMultipartyResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendTonesError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SendTonesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendTonesResponse(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::SendTonesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallAddedError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallAddedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallAddedSignal(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallAddedSignal >& signal) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallRemovedError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallRemovedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onCallRemovedSignal(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::CallRemovedSignal >& signal) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::VoiceCallManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCallManager::PropertyChangedSignal >& signal) override;

private:
   /**
    * This method is used to notify the EmergencyNumbers changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onEmergencyNumbersChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to handle the voice calls added, and updates to EvoBtStackWrapper
    *
    * @param[in] voiceCallObjPath - voice call object path
    * @param[in] inProperties - map with properties (mutable)
    * @param[in] busType      - dbus bus type
    * @param[in] busName      - dbus bus name
    * @param[in] objPath      - object path
    * @param[in] interfaceName- interface name
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void handleCallAdded(const ObjectPath& voiceCallObjPath,
         ::std::map< ::std::string, ::asf::dbus::DBusVariant >& inProperties, const ::ccdbusif::DbusBusType busType,
         const ::ccdbusif::DbusBusName& busName, const ObjectPath& objPath, const ::std::string& interfaceName);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf_h
