/**
 * @file EvolutionGeniviDbusHfpVoiceCallCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpVoiceCall
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpVoiceCallCallBackIf_h
#define EvolutionGeniviDbusHfpVoiceCallCallBackIf_h

#include "IEvolutionGeniviDbusHfpVoiceCallCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

//class forward declarations
class IBtStackWrapper;

/**
 * HfpVoiceCall callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallCallBackIf : public IEvolutionGeniviDbusHfpVoiceCallCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpVoiceCallCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpVoiceCallCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpVoiceCallCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HangupError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HangupResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAnswerError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::AnswerError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAnswerResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::AnswerResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HoldError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HoldResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::PropertyChangedSignal >& signal) override;

private:
   /**
    * This method is used to notify the VoiceCallLineIdentification changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallLineIdentificationChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceCallName changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallNameChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceCallMultiparty changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallMultipartyChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceCallState changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallStateChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceCallEmergency changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallEmergencyChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceCallDirection changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallDirectionChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceCallMode changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallModeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceCallType changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceCallTypeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpVoiceCallCallBackIf_h
