/**
 * @file EvolutionGeniviDbusHfpSiriRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpSiri
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpSiriRequestIf_h
#define EvolutionGeniviDbusHfpSiriRequestIf_h

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpSiriRequestIf.h"
#include "ProxyManager.h"
#include "org/ofono/evo/SiriProxy.h"
#include "asf/core/Proxy.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpSiriCallBackIf;

/**
 * HfpSiri proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpSiriRequestIf final :
   public ServiceAvailableIF,
   public ::ccdbusif::ICcDbusIfCreateProxy,
   public ::ccdbusif::ICcDbusIfDestroyProxy,
   public ::ccdbusif::ICcDbusIfCreateRuntimeProxy,
   public ::ccdbusif::ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpSiriRequestIf
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpSiriRequestIf();

   /**
    * Destructor of EvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpSiriRequestIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpSiriCallBackIf* callbackIf) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void deviceCreated(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void deviceRemoved(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendEnableRequest(const ::std::string& objPath, uint16 vendor_id, uint16 product_id, uint16 version, uint16 support_type) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendSetNRRequest(const ::std::string& objPath, uint8 status) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const bool value) override;

private:
   ::ccdbusif::ProxyManager< ::org::ofono::evo::Siri::SiriProxy > _hfpSiriProxy; /**< ProxyManager for Siri */
   IEvolutionGeniviDbusHfpSiriCallBackIf* _callbackIf; /**< pointer to Siri callback interface */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpSiriRequestIf_h
