/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpNetworkOperator
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpNetworkOperatorRequestIf_h
#define EvolutionGeniviDbusHfpNetworkOperatorRequestIf_h

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpNetworkOperatorRequestIf.h"
#include "ProxyManager.h"
#include "org/ofono/NetworkOperatorProxy.h"
#include "asf/core/Proxy.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf;

/**
 * HfpNetworkOperator proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkOperatorRequestIf final :
   public ServiceAvailableIF,
   public ::ccdbusif::ICcDbusIfCreateProxy,
   public ::ccdbusif::ICcDbusIfDestroyProxy,
   public ::ccdbusif::ICcDbusIfCreateRuntimeProxy,
   public ::ccdbusif::ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpNetworkOperatorRequestIf
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkOperatorRequestIf();

   /**
    * Destructor of EvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpNetworkOperatorRequestIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf* callbackIf) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void networkOperatorCreated(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void networkOperatorRemoved(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) override;

private:
   ::ccdbusif::ProxyManager< ::org::ofono::NetworkOperator::NetworkOperatorProxy > _hfpNetworkOperatorProxy;
                                                                  /**< ProxyManager for NetworkOperator */
   IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf* _callbackIf; /**< pointer to NetworkOperator callback interface */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpNetworkOperatorRequestIf_h
