/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpNetworkOperator
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpNetworkOperatorProperties_h
#define EvolutionGeniviDbusHfpNetworkOperatorProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpNetworkOperator properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkOperatorProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpNetworkOperatorProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkOperatorProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpNetworkOperatorProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpNetworkOperatorProperties();

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpNetworkOperatorProperty - property enum value
    */
   HfpNetworkOperatorProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpNetworkOperatorProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpNetworkOperatorProperty value) const;

private:
   const ::std::string _propertyStatus; /**< property Status */
   const ::std::string _propertyName;   /**< property Name */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpNetworkOperatorProperties_h
