/**
 * @file EvolutionGeniviDbusHfpModemRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpModem
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpModemRequestIf_h
#define EvolutionGeniviDbusHfpModemRequestIf_h

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpModemRequestIf.h"
#include "ProxyManager.h"
#include "org/ofono/ModemProxy.h"
#include "asf/core/Proxy.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpModemCallBackIf;

/**
 * HfpModem proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpModemRequestIf final :
   public ServiceAvailableIF,
   public ::ccdbusif::ICcDbusIfCreateProxy,
   public ::ccdbusif::ICcDbusIfDestroyProxy,
   public ::ccdbusif::ICcDbusIfCreateRuntimeProxy,
   public ::ccdbusif::ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpModemRequestIf
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpModemRequestIf();

   /**
    * Constructor of EvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpModemRequestIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpModemCallBackIf* callbackIf) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void modemCreated(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void modemRemoved(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property,
         const bool value) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendAcceptSCOConnectRequest(const ::std::string& objPath) override;

private:
   ::ccdbusif::ProxyManager< ::org::ofono::Modem::ModemProxy > _hfpModemProxy; /**< ProxyManager for Modem */
   IEvolutionGeniviDbusHfpModemCallBackIf* _callbackIf; /**< pointer to Modem callback interface */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpModemRequestIf_h
