/**
 * @file EvolutionGeniviDbusHfpManagerCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpManagerCallBackIf_h
#define EvolutionGeniviDbusHfpManagerCallBackIf_h

#include "IEvolutionGeniviDbusHfpManagerCallBackIf.h"
#include "CcDbusIfTypes.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

//forward declarations
class IBtStackWrapper;

/**
 * HfpManager callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpManagerCallBackIf : public IEvolutionGeniviDbusHfpManagerCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpManagerCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpManagerCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpManagerCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetModemsError(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::GetModemsError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetModemsResponse(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::GetModemsResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemAddedError(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemAddedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemAddedSignal(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemAddedSignal >& signal) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemRemovedError(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemRemovedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpManagerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onModemRemovedSignal(const ::boost::shared_ptr< ::org::ofono::Manager::ManagerProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Manager::ModemRemovedSignal >& signal) override;

private:
   /**
    * This method is used to convert the dbus device address (with colons) type to internal type (without colons)
    *
    * @param[in] stringOutput - output device address
    * @param[in] stringInput - input device address
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void convertBdAddress2InternalValue(::std::string& stringOutput, const ::std::string& stringInput);

   /**
    * This method is used to handle the added modems, and updates to EvoBtStackWrapper
    *
    * @param[in] modemObjPath - modem object path
    * @param[in] inProperties - map with properties (mutable)
    * @param[in] busType      - dbus bus type
    * @param[in] busName      - dbus bus name
    * @param[in] objPath      - object path
    * @param[in] interfaceName- interface name
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void handleModemAdded(const ::std::string& modemObjPath,
         ::std::map< ::std::string, ::asf::dbus::DBusVariant >& inProperties, const ::ccdbusif::DbusBusType busType,
         const ::std::string& busName, const ::std::string& objPath, const ::std::string& interfaceName);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpManagerCallBackIf_h
