/**
 * @file EvolutionGeniviDbusHfpHandsfreeProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpHandsfree
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpHandsfreeProperties_h
#define EvolutionGeniviDbusHfpHandsfreeProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpHandsfree properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpHandsfreeProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpHandsfreeProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpHandsfreeProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpHandsfreeProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpHandsfreeProperties();

   /**
    * This method is used to retrieve the features string to enum list
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return features2EnumList
    */
   inline const ::std::map< std::string, int >& getFeatures2EnumList(void) const { return _features2EnumList; }

   /**
    * This method is used to retrieve the features string to enum list pointer
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return pointer to features2EnumList
    */
   inline const ::std::map< std::string, int >* getFeatures2EnumListPtr(void) const { return &_features2EnumList; }

   /**
    * This method is used to retrieve the features enum to string list
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return enum2FeaturesList
    */
   inline const ::std::map< int, const std::string* >& getFeatures2StringList(void) const { return _enum2FeaturesList; }

   /**
    * This method is used to retrieve the features enum to string list pointer
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return pointer to enum2FeaturesList
    */
   inline const ::std::map< int, const std::string* >* getFeatures2StringListPtr(void) const { return &_enum2FeaturesList; }

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpHandsfreeProperty - property enum value
    */
   HfpHandsfreeProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the feature string to enum value
    *
    * @param[in] value - feature name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpHandsfreeFeatures - feature enum value
    */
   HfpHandsfreeFeatures getFeatures2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the chld feature string to enum value
    *
    * @param[in] value - chld feature name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpHandsfreeChldFeatureSuppValues - chld feature enum value
    */
   HfpHandsfreeChldFeatureSuppValues getChldFeature2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpHandsfreeProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpHandsfreeProperty value) const;

   /**
    * This method is used to convert the feature enum value to string
    *
    * @param[in] value - feature enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - feature name
    */
   const ::std::string& getFeatures2String(const HfpHandsfreeFeatures value) const;

   /**
    * This method is used to convert the feature enum value to trace string
    *
    * @param[in] value - feature enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - feature name
    */
   const ::std::string& getFeatures2StringTrace(const HfpHandsfreeFeatures value) const;

   /**
    * This method is used to convert the chld feature enum value to string
    *
    * @param[in] value - chld feature enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - chld feature name
    */
   const ::std::string& getChldFeature2String(const HfpHandsfreeChldFeatureSuppValues value) const;

private:
   const ::std::string _propertyFeatures;                         /**< property Features */
   const ::std::string _propertyInbandRinging;                    /**< property InbandRinging */
   const ::std::string _propertyVoiceRecognition;                 /**< property VoiceRecognition */
   const ::std::string _propertyEchoCancelingNoiseReduction;      /**< property EchoCancelingNoiseReduction */
   const ::std::string _propertyBatteryChargeLevel;               /**< property BatteryChargeLevel */
   const ::std::string _propertyAudio;                            /**< property Audio */
   const ::std::string _propertySCOType;                          /**< property SCOType */
   const ::std::string _propertyAudioPath;                        /**< property AudioPath */
   const ::std::string _propertyAllCallStatus;                    /**< property AllCallStatus */
   const ::std::string _propertyChldFeature;                      /**< property ChldFeature */
   const ::std::string _propertyAudioIndicator;                   /**< property AudioIndicator */

   const ::std::string _featuresVoice_recognition;                /**< features Voice_recognition */
   const ::std::string _featuresAttach_voice_tag;                 /**< features Attach_voice_tag */
   const ::std::string _features3way;                             /**< features 3way */
   const ::std::string _featuresECNR;                             /**< features ECNR */
   const ::std::string _featuresInband_ring;                      /**< features Inband_ring*/
   const ::std::string _featuresReject_incoming_call;             /**< features Reject_incoming_call */
   const ::std::string _featuresEnhanced_call_status;             /**< features Enhanced_call_status */
   const ::std::string _featuresEnhanced_call_control;            /**< features Enhanced_call_control */
   const ::std::string _featuresExtended_error_codes;             /**< features Extended_error_codes */
   const ::std::string _featuresCodec_negotiation;                /**< features Codec_negotiation */
   const ::std::string _featuresHF_indicators;                    /**< features HF_indicators */
   const ::std::string _featureseSCO_S4_and_T2_Setting_supported; /**< features SCO_S4_and_T2_Setting_supported */

   const ::std::string _chldFeature_0;                            /**< chldFeature 0 */
   const ::std::string _chldFeature_1;                            /**< chldFeature 1 */
   const ::std::string _chldFeature_1x;                           /**< chldFeature 1x */
   const ::std::string _chldFeature_2;                            /**< chldFeature 2 */
   const ::std::string _chldFeature_2x;                           /**< chldFeature 2x */
   const ::std::string _chldFeature_3;                            /**< chldFeature 3 */
   const ::std::string _chldFeature_4;                            /**< chldFeature 4 */

   ::std::map< std::string, int > _features2EnumList;             /**< map with supported value for Features + enum pairs */
   ::std::map< int, const std::string* > _enum2FeaturesList;      /**< map with enum + supported value for Features pairs */

   ::std::map< std::string, int > _chldFeature2EnumList;          /**< map with supported value for ChldFeature + enum pairs */
   ::std::map< int, const std::string* > _enum2ChldFeatureList;   /**< map with enum + supported value for ChldFeature pairs */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpHandsfreeProperties_h
