/**
 * @file EvolutionGeniviDbusHfpCallVolumeProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpCallVolume
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpCallVolumeProperties_h
#define EvolutionGeniviDbusHfpCallVolumeProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpCallVolume properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpCallVolumeProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpCallVolumeProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpCallVolumeProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpCallVolumeProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpCallVolumeProperties();

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpCallVolumeProperty - property enum value
    */
   HfpCallVolumeProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpCallVolumeProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpCallVolumeProperty value) const;

private:
   const ::std::string _propertySpeakerVolume;    /**< property SpeakerVolume */
   const ::std::string _propertyMicrophoneVolume; /**< property MicrophoneVolume */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpCallVolumeProperties_h
