/**
 * @file EvolutionGeniviDbusHfpCallVolumeCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpCallVolume
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpCallVolumeCallBackIf_h
#define EvolutionGeniviDbusHfpCallVolumeCallBackIf_h

#include "IEvolutionGeniviDbusHfpCallVolumeCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

//class forward declarations
class IBtStackWrapper;

/**
 * HfpCallVolume callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpCallVolumeCallBackIf : public IEvolutionGeniviDbusHfpCallVolumeCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpCallVolumeCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpCallVolumeCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpCallVolumeCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::SetPropertyError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::SetPropertyResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpCallVolumeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::CallVolume::CallVolumeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::CallVolume::PropertyChangedSignal >& signal) override;

private:
   /**
    * This method is used to notify the SpeakerVolume changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onSpeakerVolumeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the MicrophoneVolume changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onMicrophoneVolumeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpCallVolumeCallBackIf_h
