/**
 * @file CcDbusIfUtils.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief CcDbusIf Utilities.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Utilities for CcDbusIf.
 */

#include "CcDbusIfUtils.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcDbusIfUtils.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace ccdbusif {

DbusBusType convertDBusBusType(const ::DBusBusType type)
{
   DbusBusType returnType(BUS_TYPE_SYSTEM);

   if(DBUS_BUS_SESSION == type)
   {
      returnType = BUS_TYPE_SESSION;
   }

   return returnType;
}

::DBusBusType convertLocalBusType(const DbusBusType type)
{
   ::DBusBusType returnType(DBUS_BUS_SYSTEM);

   if(BUS_TYPE_SESSION == type)
   {
      returnType = DBUS_BUS_SESSION;
   }

   return returnType;
}

DbusBusType convertConnectorOption2BusType(const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions)
{
   DbusBusType returnType;

   if(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System == connectorOptions.getBusType())
   {
      returnType = BUS_TYPE_SYSTEM;
   }
   else if(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session == connectorOptions.getBusType())
   {
      returnType = BUS_TYPE_SESSION;
   }
   else if(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Address == connectorOptions.getBusType())
   {
      returnType = BUS_TYPE_ADDRESS;
   }
   else
   {
      ETG_TRACE_ERR(("CcDbusIfUtils::convertConnectorOption2BusType BUS_TYPE_UNKNOWN"));
      returnType = BUS_TYPE_SYSTEM;
   }

   return returnType;
}

void convertBusType2ConnectorOption(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions, const DbusBusType type)
{
   if(BUS_TYPE_SYSTEM == type)
   {
      connectorOptions.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
   }
   else if(BUS_TYPE_SESSION == type)
   {
      connectorOptions.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
   }
   else if(BUS_TYPE_ADDRESS == type)
   {
      connectorOptions.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Address);
   }
   else
   {
      ETG_TRACE_ERR(("CcDbusIfUtils::convertBusType2ConnectorOption BUS_TYPE_UNKNOWN"));
      connectorOptions.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
   }
}

} //ccdbusif
